/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.sampling.list;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ListSlidingWindows {
    public static <T> Stream<List<T>> createClosedSlidingWindow(List<? extends T> input, int windowSize, int stepSize) {
        int start = 0;
        int maxEnd = input.size();
        return ListSlidingWindows.createSlidingWindow(input, windowSize, start, maxEnd, stepSize);
    }

    static <T> Stream<List<T>> createOpenSlidingWindow(List<? extends T> input, int windowSize, int stepSize) {
        int start = -windowSize + 1;
        int maxEnd = input.size() + windowSize;
        return ListSlidingWindows.createSlidingWindow(input, windowSize, start, maxEnd, stepSize);
    }

    public static <T> Stream<List<T>> createSlidingWindow(List<? extends T> input, int windowSize, int start, int maxEnd, int stepSize) {
        Iterator<List<? extends T>> iterator = ListSlidingWindows.createSlidingWindowIterator(input, windowSize, start, maxEnd, stepSize);
        Spliterator<List<? extends T>> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream<List<T>> stream = StreamSupport.stream(spliterator, false);
        return stream;
    }

    private static <T> Iterator<List<T>> createSlidingWindowIterator(final List<? extends T> input, final int windowSize, final int start, final int maxEnd, final int stepSize) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("The window size must be positive, but is " + windowSize);
        }
        if (stepSize <= 0) {
            throw new IllegalArgumentException("The step size must be positive, but is " + stepSize);
        }
        return new Iterator<List<T>>(){
            private int currentIndex;
            {
                this.currentIndex = start;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex < input.size() && this.currentIndex + windowSize <= maxEnd;
            }

            @Override
            public List<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                int fromIndex = Math.max(this.currentIndex, 0);
                int to = this.currentIndex + windowSize;
                int toIndex = Math.min(Math.max(to, 0), input.size());
                List result = Collections.unmodifiableList(input.subList(fromIndex, toIndex));
                this.currentIndex += stepSize;
                return result;
            }
        };
    }

    private ListSlidingWindows() {
    }
}

