/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.sampling.list;

import java.awt.Point;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ListSplitting {
    public static <T> Stream<List<T>> extractChunks(final List<T> list, final int numChunks) {
        if (numChunks < 1) {
            throw new IllegalArgumentException("The number of chunks must be at least 1, but is " + numChunks);
        }
        Iterator iterator = new Iterator<List<T>>(){
            private int chunkCounter = 0;

            @Override
            public boolean hasNext() {
                return this.chunkCounter < numChunks;
            }

            @Override
            public List<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                List result = ListSplitting.extractChunk(list, numChunks, this.chunkCounter);
                ++this.chunkCounter;
                return result;
            }
        };
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream<List<T>> stream = StreamSupport.stream(spliterator, false);
        return stream;
    }

    public static <T> Stream<List<T>> omitChunks(final List<T> list, final int numChunks) {
        if (numChunks < 1) {
            throw new IllegalArgumentException("The number of chunks must be at least 1, but is " + numChunks);
        }
        Iterator iterator = new Iterator<List<T>>(){
            private int chunkCounter = 0;

            @Override
            public boolean hasNext() {
                return this.chunkCounter < numChunks;
            }

            @Override
            public List<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                List result = ListSplitting.omitChunk(list, numChunks, this.chunkCounter);
                ++this.chunkCounter;
                return result;
            }
        };
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream<List<T>> stream = StreamSupport.stream(spliterator, false);
        return stream;
    }

    public static <T> List<T> extractChunk(List<? extends T> list, int numChunks, int chunkIndex) {
        ListSplitting.validateChunk(numChunks, chunkIndex);
        Point indexRange = ListSplitting.computeChunkIndexRange(list.size(), numChunks, chunkIndex);
        return Collections.unmodifiableList(list.subList(indexRange.x, indexRange.y));
    }

    public static <T> List<T> omitChunk(List<? extends T> list, int numChunks, int chunkIndex) {
        ListSplitting.validateChunk(numChunks, chunkIndex);
        Point indexRange = ListSplitting.computeChunkIndexRange(list.size(), numChunks, chunkIndex);
        return ListSplitting.inverseSubList(list, indexRange.x, indexRange.y);
    }

    private static Point computeChunkIndexRange(int listSize, int numChunks, int chunkIndex) {
        int stepSize = listSize / numChunks;
        int remainder = listSize % numChunks;
        if (chunkIndex < remainder) {
            int fromIndex = chunkIndex * stepSize + chunkIndex;
            int toIndex = fromIndex + stepSize + 1;
            return new Point(fromIndex, toIndex);
        }
        int fromIndex = chunkIndex * stepSize + remainder;
        int toIndex = fromIndex + stepSize;
        return new Point(fromIndex, toIndex);
    }

    private static void validateChunk(int numChunks, int chunkIndex) {
        if (numChunks < 1) {
            throw new IllegalArgumentException("The number of chunks must be at least 1, but is " + numChunks);
        }
        if (chunkIndex < 0) {
            throw new IllegalArgumentException("The chunk index may not be negative, but is " + chunkIndex);
        }
        if (chunkIndex >= numChunks) {
            throw new IllegalArgumentException("The chunk index is " + chunkIndex + ", but must be smaller than the number of chunks, which is " + numChunks);
        }
    }

    private static <T> List<T> inverseSubList(final List<? extends T> list, final int fromIndex, int toIndex) {
        final int omittedSize = toIndex - fromIndex;
        AbstractList result = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < fromIndex) {
                    return list.get(index);
                }
                return list.get(index + omittedSize);
            }

            @Override
            public int size() {
                return list.size() - omittedSize;
            }
        };
        return result;
    }

    private ListSplitting() {
    }
}

