/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.sampling.list;

import java.util.Random;

class RandomUtils {
    static int[] randomSample(int size, int min, int max, Random random) {
        if (size < 0) {
            throw new IllegalArgumentException("The size may not be negative, but is " + size);
        }
        if (min > max) {
            throw new IllegalArgumentException("The minimum is " + min + ", which is larger than the maximum " + max);
        }
        if (size > max - min) {
            throw new IllegalArgumentException("Can not create a sample of size " + size + " with values between " + min + " and " + max);
        }
        return RandomUtils.reservoirSampling(size, min, max, random);
    }

    private static int[] reservoirSampling(int size, int min, int max, Random random) {
        int i;
        int[] reservoir = new int[size];
        for (i = 0; i < size; ++i) {
            reservoir[i] = i + min;
        }
        for (i = size; i < max - min; ++i) {
            int j = random.nextInt(i + 1);
            if (j >= size) continue;
            reservoir[j] = i + min;
        }
        return reservoir;
    }

    private RandomUtils() {
    }
}

