/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.selection;

import de.javagl.selection.SelectionEvent;
import de.javagl.selection.SelectionListener;
import de.javagl.selection.SelectionModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

abstract class AbstractSelectionModel<T>
implements SelectionModel<T> {
    private final List<SelectionListener<T>> selectionListeners = new CopyOnWriteArrayList<SelectionListener<T>>();

    protected AbstractSelectionModel() {
    }

    @Override
    public void addSelectionListener(SelectionListener<T> selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    @Override
    public void removeSelectionListener(SelectionListener<T> selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    protected final void fireSelectionChanged(T addedElement, T removedElement) {
        if (!this.selectionListeners.isEmpty()) {
            Set addedElements = addedElement != null ? Collections.singleton(addedElement) : Collections.emptySet();
            Set removedElements = removedElement != null ? Collections.singleton(removedElement) : Collections.emptySet();
            SelectionEvent selectionEvent = new SelectionEvent(this, addedElements, removedElements);
            for (SelectionListener selectionListener : this.selectionListeners) {
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }

    protected final void fireSelectionChanged(Set<T> addedElements, Set<T> removedElements) {
        if (!this.selectionListeners.isEmpty()) {
            if (addedElements == null) {
                addedElements = Collections.emptySet();
            }
            if (removedElements == null) {
                removedElements = Collections.emptySet();
            }
            SelectionEvent<T> selectionEvent = new SelectionEvent<T>(this, addedElements, removedElements);
            for (SelectionListener<T> selectionListener : this.selectionListeners) {
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }
}

