/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.selection;

import de.javagl.selection.AbstractSelectionModel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class DefaultSelectionModel<T>
extends AbstractSelectionModel<T> {
    private final Set<T> selection = new LinkedHashSet<T>();
    private final Set<T> selectionView = Collections.unmodifiableSet(this.selection);

    DefaultSelectionModel() {
    }

    @Override
    public void addToSelection(T element) {
        boolean changed = this.selection.add(element);
        if (changed) {
            this.fireSelectionChanged(element, null);
        }
    }

    @Override
    public void removeFromSelection(T element) {
        boolean changed = this.selection.remove(element);
        if (changed) {
            this.fireSelectionChanged(null, element);
        }
    }

    @Override
    public void addToSelection(Collection<? extends T> elements) {
        LinkedHashSet<T> addedElements = new LinkedHashSet<T>();
        for (T element : elements) {
            boolean wasAdded = this.selection.add(element);
            if (!wasAdded) continue;
            addedElements.add(element);
        }
        if (!addedElements.isEmpty()) {
            this.fireSelectionChanged(Collections.unmodifiableSet(addedElements), null);
        }
    }

    @Override
    public void removeFromSelection(Collection<? extends T> elements) {
        LinkedHashSet<T> removedElements = new LinkedHashSet<T>();
        for (T element : elements) {
            boolean wasRemoved = this.selection.remove(element);
            if (!wasRemoved) continue;
            removedElements.add(element);
        }
        if (!removedElements.isEmpty()) {
            this.fireSelectionChanged(null, Collections.unmodifiableSet(removedElements));
        }
    }

    @Override
    public void setSelection(Collection<? extends T> elements) {
        if (!this.selection.equals(elements)) {
            LinkedHashSet<T> removedElements = new LinkedHashSet<T>(this.selection);
            LinkedHashSet<T> addedElements = new LinkedHashSet<T>(elements);
            removedElements.removeAll(addedElements);
            addedElements.removeAll(this.selection);
            this.selection.clear();
            this.selection.addAll(elements);
            if (!addedElements.isEmpty() || !removedElements.isEmpty()) {
                this.fireSelectionChanged(Collections.unmodifiableSet(addedElements), Collections.unmodifiableSet(removedElements));
            }
        }
    }

    @Override
    public void clear() {
        if (!this.selection.isEmpty()) {
            LinkedHashSet<T> removedElements = new LinkedHashSet<T>(this.selection);
            this.selection.clear();
            this.fireSelectionChanged(null, removedElements);
        }
    }

    @Override
    public boolean isSelected(T element) {
        return this.selection.contains(element);
    }

    @Override
    public Set<T> getSelection() {
        return this.selectionView;
    }
}

