/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.selection;

import de.javagl.selection.SelectionEvent;
import de.javagl.selection.SelectionListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingSelectionListener<T>
implements SelectionListener<T> {
    private static final Logger logger = Logger.getLogger(LoggingSelectionListener.class.getName());
    private Level level = Level.INFO;

    public LoggingSelectionListener() {
        this(Level.INFO);
    }

    public LoggingSelectionListener(Level level) {
        this.level = level;
    }

    public void setLogLevel(Level level) {
        this.level = level;
    }

    @Override
    public void selectionChanged(SelectionEvent<T> selectionEvent) {
        if (logger.isLoggable(this.level)) {
            int threshold = 10;
            Set<T> added = selectionEvent.getAddedElements();
            Set<T> removed = selectionEvent.getRemovedElements();
            Set<T> selected = selectionEvent.getSelectionModel().getSelection();
            logger.log(this.level, "selectionChanged");
            logger.log(this.level, "    added   : " + added.size() + " elements: " + (added.size() > threshold ? "(String omitted)" : added));
            logger.log(this.level, "    removed : " + removed.size() + " elements: " + (removed.size() > threshold ? "(String omitted)" : removed));
            logger.log(this.level, "    selected: " + selected.size() + " elements: " + (selected.size() > threshold ? "(String omitted)" : selected));
        }
    }
}

