/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.validation;

import de.javakaffee.validation.EntityManagerAwareValidator;
import javax.persistence.EntityManagerFactory;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintValidatorFactoryEMFImpl
implements ConstraintValidatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintValidatorFactoryEMFImpl.class);
    private final EntityManagerFactory entityManagerFactory;

    public ConstraintValidatorFactoryEMFImpl(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        ConstraintValidator instance = null;
        try {
            instance = (ConstraintValidator)key.newInstance();
        }
        catch (Exception e) {
            LOG.error("Could not instantiate " + key.getName(), (Throwable)e);
            return null;
        }
        if (EntityManagerAwareValidator.class.isAssignableFrom(key)) {
            EntityManagerAwareValidator validator = (EntityManagerAwareValidator)instance;
            validator.setEntityManager(this.entityManagerFactory.createEntityManager());
        }
        return (T)instance;
    }
}

