/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImmutableMultimapSerializer
extends Serializer<ImmutableMultimap<Object, Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;
    private ImmutableMapSerializer mapSerializer;

    private ImmutableMultimapSerializer() {
        super(true, true);
    }

    private ImmutableMultimapSerializer(ImmutableMapSerializer mapSerializer) {
        this();
        this.mapSerializer = mapSerializer;
    }

    public void write(Kryo kryo, Output output, ImmutableMultimap<Object, Object> immutableMultiMap) {
        this.mapSerializer.write(kryo, output, (ImmutableMap<Object, ? extends Object>)ImmutableMap.copyOf((Map)immutableMultiMap.asMap()));
    }

    public ImmutableMultimap<Object, Object> read(Kryo kryo, Input input, Class<ImmutableMultimap<Object, Object>> type) {
        Class<HashMap> hashMapClass = HashMap.class;
        ImmutableMap<Object, Object> map = this.mapSerializer.read(kryo, input, hashMapClass);
        Set entries = map.entrySet();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry entry : entries) {
            builder.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.build();
    }

    protected static void registerSerializers(Kryo kryo) {
        Serializer immutableMapSerializer;
        Serializer immutableListSerializer = kryo.getSerializer(ImmutableList.class);
        if (!(immutableListSerializer instanceof ImmutableListSerializer)) {
            ImmutableListSerializer.registerSerializers(kryo);
        }
        if (!((immutableMapSerializer = kryo.getSerializer(ImmutableMap.class)) instanceof ImmutableMapSerializer)) {
            ImmutableMapSerializer.registerSerializers(kryo);
        }
        ImmutableMultimapSerializer serializer = new ImmutableMultimapSerializer((ImmutableMapSerializer)kryo.getSerializer(ImmutableMap.class));
        kryo.register(ImmutableMultimap.class, (Serializer)serializer);
        kryo.register(ImmutableMultimap.of().getClass(), (Serializer)serializer);
        Object o = new Object();
        kryo.register(ImmutableMultimap.of((Object)o, (Object)o).getClass(), (Serializer)serializer);
    }
}

