/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;

public class JdkProxySerializer
extends SimpleSerializer<Object> {
    private final Kryo _kryo;

    public JdkProxySerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    public Object read(ByteBuffer buffer) {
        InvocationHandler invocationHandler = (InvocationHandler)this._kryo.readClassAndObject(buffer);
        Class[] interfaces = (Class[])this._kryo.readObjectData(buffer, Class[].class);
        ClassLoader classLoader = this._kryo.getClassLoader();
        try {
            return Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        }
        catch (RuntimeException e) {
            System.err.println(((Object)((Object)this)).getClass().getName() + ".read:\n" + "Could not create proxy using classLoader " + classLoader + "," + " have invoctaionhandler.classloader: " + invocationHandler.getClass().getClassLoader() + " have contextclassloader: " + Thread.currentThread().getContextClassLoader());
            throw e;
        }
    }

    public void write(ByteBuffer buffer, Object obj) {
        this._kryo.writeClassAndObject(buffer, (Object)Proxy.getInvocationHandler(obj));
        this._kryo.writeObjectData(buffer, obj.getClass().getInterfaces());
    }
}

