/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.simplequeue;

import de.javakaffee.simplequeue.BDBQueue;
import de.javakaffee.simplequeue.Consumer;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RichBDBQueue<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RichBDBQueue.class);
    private final ObjectMapper _mapper;
    private final BDBQueue _q;
    private final Class<T> _type;
    private long pauseTimeInMillis = 100L;
    private volatile boolean _doRun = true;
    private final Object _monitor = new Object();

    public RichBDBQueue(File queueBaseDir, String queueName, int cacheSize, Class<T> type) throws IOException {
        this._mapper = this.createObjectMapper();
        if (!this._mapper.canSerialize(type)) {
            throw new IllegalArgumentException("The given type cannot be serialized by jackson (checked with new ObjectMapper().canSerialize(type)).");
        }
        this._q = new BDBQueue(queueBaseDir.getAbsolutePath(), queueName, cacheSize);
        this._type = type;
    }

    protected ObjectMapper createObjectMapper() {
        return new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(T object) throws IOException {
        byte[] data = this._mapper.writeValueAsBytes(object);
        this._q.push(data);
        Object object2 = this._monitor;
        synchronized (object2) {
            this._monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Consumer<T> consumer) throws IOException, InterruptedException {
        while (this._doRun) {
            boolean queueEmpty;
            Object object = this._q;
            synchronized (object) {
                queueEmpty = !this.processMessage(consumer);
            }
            if (!queueEmpty) continue;
            object = this._monitor;
            synchronized (object) {
                this._monitor.wait();
            }
        }
    }

    private boolean processMessage(Consumer<T> consumer) throws IOException {
        byte[] data = this._q.peek();
        T item = this.deserialize(data);
        if (item != null) {
            try {
                boolean success = consumer.consume(item);
                if (success) {
                    this._q.remove();
                }
            }
            catch (RuntimeException e) {
                LOG.error("Consumer could not read object.", (Throwable)e);
            }
        }
        return data != null;
    }

    public void clear() {
        this._q.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        BDBQueue bDBQueue = this._q;
        synchronized (bDBQueue) {
            this._doRun = false;
            Object object = this._monitor;
            synchronized (object) {
                this._monitor.notifyAll();
            }
            LOG.info("Closing queue.");
            this._q.close();
        }
    }

    public boolean isEmpty() {
        return this._q.isEmpty();
    }

    public T peek() throws IOException {
        byte[] data = this._q.peek();
        return this.deserialize(data);
    }

    public void remove() {
        this._q.remove();
    }

    public long size() {
        return this._q.size();
    }

    private T deserialize(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (T)this._mapper.readValue(data, 0, data.length, this._type);
        }
        catch (Exception e) {
            LOG.error("Element could not be deserialized, item will be removed. Data: {}", (Object)new Object[]{data}, (Object)e);
            this._q.remove();
            return null;
        }
    }

    public long getPauseTimeInMillis() {
        return this.pauseTimeInMillis;
    }

    public void setPauseTimeInMillis(long pauseTimeInMillis) {
        this.pauseTimeInMillis = pauseTimeInMillis;
    }

    BDBQueue getQ() {
        return this._q;
    }

    ObjectMapper getMapper() {
        return this._mapper;
    }
}

