/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.api;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Map;
import java.util.TreeMap;

public class JsonToMapBuilder {
    public Map<String, Object> toMap(JsonValue jsonValue) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (!jsonValue.isObject()) {
            return map;
        }
        JsonObject jsonObject = jsonValue.asObject();
        for (JsonObject.Member member : jsonObject) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (value.isObject()) {
                map.put(name, this.toMap(value));
                continue;
            }
            if (value.isBoolean()) {
                map.put(name, value.asBoolean());
                continue;
            }
            if (value.isString()) {
                map.put(name, value.asString());
                continue;
            }
            if (value.isNull() || !value.isNumber()) continue;
            boolean resolved = false;
            resolved = resolved || this.tryToResolveAsInteger(name, value, map);
            resolved = resolved || this.tryToResolveAsLong(name, value, map);
            resolved = resolved || this.tryToResolveAsFloat(name, value, map);
            resolved = resolved || this.tryToResolveAsDouble(name, value, map);
        }
        return map;
    }

    private boolean tryToResolveAsFloat(String name, JsonValue value, Map<String, Object> map) {
        try {
            map.put(name, Float.valueOf(value.asFloat()));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean tryToResolveAsDouble(String name, JsonValue value, Map<String, Object> map) {
        try {
            map.put(name, value.asDouble());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean tryToResolveAsInteger(String name, JsonValue value, Map<String, Object> map) {
        try {
            map.put(name, value.asInt());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean tryToResolveAsLong(String name, JsonValue value, Map<String, Object> map) {
        try {
            map.put(name, value.asInt());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

