/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.api;

import de.jcup.asp.api.AbstractProtocolObject;
import de.jcup.asp.api.MapResponseResultKey;
import de.jcup.asp.api.ProtocolData;
import de.jcup.asp.api.ProtocolDataException;
import de.jcup.asp.api.ResponseResultKey;
import de.jcup.asp.api.ServerLog;
import de.jcup.asp.api.StringResponseResultKey;
import de.jcup.asp.api.ValueProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class Response
extends AbstractProtocolObject {
    public static final String TERMINATOR = "--RESPONSE-TERMINATE--";

    public <T> void set(ResponseResultKey<T> key, ValueProvider<T> provider) {
        this.internalSet(key, provider);
    }

    public void set(ResponseResultKey<String> key, String value) {
        this.internalSet(key, value);
    }

    public void setServerLog(ServerLog log) {
        this.internalSet(StringResponseResultKey.SERVER_LOGS, log.convertToString());
    }

    public ServerLog getServerLog() {
        String json = this.internalGetString(StringResponseResultKey.SERVER_LOGS);
        return ServerLog.convertFromString(json);
    }

    public Path getResultFilePath() {
        String filePath = this.getString(StringResponseResultKey.RESULT_FILEPATH);
        if (filePath == null) {
            return null;
        }
        Path path = Paths.get(filePath, new String[0]);
        return path;
    }

    public Map<String, Object> getAttributes() {
        return this.getMap(MapResponseResultKey.RESULT_ATTRIBUTES);
    }

    public void set(ResponseResultKey<Map<String, Object>> mapKey, Map<String, Object> map) {
        this.internalSet(mapKey, map);
    }

    public String getString(ResponseResultKey<String> key) {
        return this.internalGetString(key);
    }

    public Map<String, Object> getMap(ResponseResultKey<Map<String, Object>> key) {
        return this.internalGetMap(key);
    }

    public static Response convertFromString(String data) {
        Response r = new Response();
        try {
            r.data = ProtocolData.convertFromString(data);
        }
        catch (ProtocolDataException e) {
            r.setErrorMessage(e.getMessage());
        }
        return r;
    }

    public String getErrorMessage() {
        return this.internalGetString(StringResponseResultKey.ERROR);
    }

    public boolean failed() {
        String error = this.getString(StringResponseResultKey.ERROR);
        return error != null && !error.isEmpty();
    }

    public void setErrorMessage(String message) {
        this.set(StringResponseResultKey.ERROR, message);
    }
}

