/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.api.asciidoc;

import de.jcup.asp.api.asciidoc.AsciidocAttribute;
import de.jcup.asp.api.asciidoc.AsciidocAttributesBuilder;
import de.jcup.asp.api.asciidoc.AsciidocCompatMode;
import de.jcup.asp.api.asciidoc.AsciidocPlacement;
import java.net.URI;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class AsciidocAttributes {
    private static Format DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static Format TIME_FORMAT = new SimpleDateFormat("HH:mm:ss z");
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    AsciidocAttributes() {
    }

    public static AsciidocAttributesBuilder builder() {
        return new AsciidocAttributesBuilder();
    }

    public void setAllowUriRead(boolean allowUriRead) {
        this.put(AsciidocAttribute.ALLOW_URI_READ, AsciidocAttributes.toAsciidoctorFlag(allowUriRead));
    }

    public void setAttributeMissing(String attributeMissing) {
        this.put(AsciidocAttribute.ATTRIBUTE_MISSING, attributeMissing);
    }

    public void setAttributeUndefined(String attributeUndefined) {
        this.put(AsciidocAttribute.ATTRIBUTE_UNDEFINED, attributeUndefined);
    }

    public void setTitle(String title) {
        this.put(AsciidocAttribute.TITLE, title);
    }

    public void setImagesDir(String imagesDir) {
        this.put(AsciidocAttribute.IMAGESDIR, imagesDir);
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.put(AsciidocAttribute.SOURCE_LANGUAGE, sourceLanguage);
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.put(AsciidocAttribute.SOURCE_HIGHLIGHTER, sourceHighlighter);
    }

    public void setMaxIncludeDepth(int maxIncludeDepth) {
        this.put(AsciidocAttribute.MAX_INCLUDE_DEPTH, maxIncludeDepth);
    }

    public void setSectNumLevels(int sectNumLevels) {
        this.put(AsciidocAttribute.SECT_NUM_LEVELS, sectNumLevels);
    }

    public void setHardbreaks(boolean hardbreaks) {
        this.put(AsciidocAttribute.HARDBREAKS, AsciidocAttributes.toAsciidoctorFlag(hardbreaks));
    }

    public void setCacheUri(boolean cacheUri) {
        this.put(AsciidocAttribute.CACHE_URI, AsciidocAttributes.toAsciidoctorFlag(cacheUri));
    }

    public void setHideUriScheme(boolean hideUriScheme) {
        this.put(AsciidocAttribute.HIDE_URI_SCHEME, AsciidocAttributes.toAsciidoctorFlag(hideUriScheme));
    }

    public void setAppendixCaption(String appendixCaption) {
        this.put(AsciidocAttribute.APPENDIX_CAPTION, appendixCaption);
    }

    public void setMath(String math) {
        this.put(AsciidocAttribute.MATH, math);
    }

    public void setSkipFrontMatter(boolean skipFrontMatter) {
        this.put(AsciidocAttribute.SKIP_FRONT_MATTER, AsciidocAttributes.toAsciidoctorFlag(skipFrontMatter));
    }

    public void setAnchors(boolean setAnchors) {
        this.put(AsciidocAttribute.SET_ANCHORS, setAnchors);
    }

    public void setUntitledLabel(String untitledLabel) {
        this.put(AsciidocAttribute.UNTITLED_LABEL, untitledLabel);
    }

    public void setIgnoreUndefinedAttributes(boolean ignoreUndefinedAttributes) {
        this.put(AsciidocAttribute.IGNORE_UNDEFINED, AsciidocAttributes.toAsciidoctorFlag(ignoreUndefinedAttributes));
    }

    public void setTableOfContents(AsciidocPlacement asciidocPlacement) {
        this.put(AsciidocAttribute.TOC, asciidocPlacement.getPosition());
    }

    public void setTocLevels(int levels) {
        this.put(AsciidocAttribute.TOC_LEVELS, levels);
    }

    public void setShowTitle(boolean showTitle) {
        if (showTitle) {
            this.put(AsciidocAttribute.SHOW_TITLE, true);
            this.attributes.remove(AsciidocAttribute.NOTITLE.getKey());
        } else {
            this.put(AsciidocAttribute.NOTITLE, true);
            this.attributes.remove(AsciidocAttribute.SHOW_TITLE.getKey());
        }
    }

    public void setTableOfContents(boolean toc) {
        if (toc) {
            this.put(AsciidocAttribute.TOC, "");
        } else {
            this.attributes.remove(AsciidocAttribute.TOC.getKey());
        }
    }

    public void setLocalDate(Date localDate) {
        this.put(AsciidocAttribute.LOCALDATE, AsciidocAttributes.toDate(localDate));
    }

    public void setLocalTime(Date localTime) {
        this.put(AsciidocAttribute.LOCALTIME, AsciidocAttributes.toTime(localTime));
    }

    public void setDocDate(Date docDate) {
        this.put(AsciidocAttribute.DOCDATE, AsciidocAttributes.toDate(docDate));
    }

    public void setDocTime(Date docTime) {
        this.put(AsciidocAttribute.DOCTIME, AsciidocAttributes.toTime(docTime));
    }

    public void setStyleSheetName(String styleSheetName) {
        this.put(AsciidocAttribute.STYLESHEET_NAME, styleSheetName);
    }

    public void unsetStyleSheet() {
        this.put(AsciidocAttribute.NOT_STYLESHEET_NAME, AsciidocAttributes.toAsciidoctorFlag(true));
    }

    public void setStylesDir(String stylesDir) {
        this.put(AsciidocAttribute.STYLES_DIR, stylesDir);
    }

    public void setLinkCss(boolean linkCss) {
        this.put(AsciidocAttribute.LINK_CSS, AsciidocAttributes.toAsciidoctorFlag(linkCss));
    }

    public void setCopyCss(boolean copyCss) {
        this.put(AsciidocAttribute.COPY_CSS, AsciidocAttributes.toAsciidoctorFlag(copyCss));
    }

    public void setIcons(String iconsName) {
        this.put(AsciidocAttribute.ICONS, iconsName);
    }

    public void setIconFontRemote(boolean iconFontRemote) {
        this.put(AsciidocAttribute.ICONFONT_REMOTE, AsciidocAttributes.toAsciidoctorFlag(iconFontRemote));
    }

    public void setIconFontCdn(URI cdnUri) {
        this.put(AsciidocAttribute.ICONFONT_CDN, cdnUri.toASCIIString());
    }

    public void setIconFontName(String iconFontName) {
        this.put(AsciidocAttribute.ICONFONT_NAME, iconFontName);
    }

    public void setDataUri(boolean dataUri) {
        this.put(AsciidocAttribute.DATA_URI, AsciidocAttributes.toAsciidoctorFlag(dataUri));
    }

    public void setIconsDir(String iconsDir) {
        this.put(AsciidocAttribute.ICONS_DIR, iconsDir);
    }

    public void setSectionNumbers(boolean sectionNumbers) {
        this.put(AsciidocAttribute.SECTION_NUMBERS, AsciidocAttributes.toAsciidoctorFlag(sectionNumbers));
    }

    public void setLinkAttrs(boolean linkAttrs) {
        this.put(AsciidocAttribute.LINK_ATTRS, AsciidocAttributes.toAsciidoctorFlag(linkAttrs));
    }

    public void setExperimental(boolean experimental) {
        this.put(AsciidocAttribute.EXPERIMENTAL, experimental);
    }

    public void setNoFooter(boolean noFooter) {
    }

    private void put(AsciidocAttribute atribute, Object object) {
        this.attributes.put(atribute.getKey(), object);
    }

    public void setCompatMode(AsciidocCompatMode asciidocCompatMode) {
        this.put(AsciidocAttribute.COMPAT_MODE, asciidocCompatMode.getMode());
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public static String toAsciidoctorFlag(boolean flag) {
        return flag ? "" : null;
    }

    private static String toDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    private static String toTime(Date time) {
        return TIME_FORMAT.format(time);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setCustomAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }
}

