/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.api.asciidoc;

import de.jcup.asp.api.asciidoc.AsciidocAttributes;
import de.jcup.asp.api.asciidoc.AsciidocOptions;
import de.jcup.asp.api.asciidoc.AsciidocSafeMode;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;

public class AsciidocOptionsBuilder {
    private final AsciidocOptions asciidocOptions = new AsciidocOptions();

    AsciidocOptionsBuilder() {
    }

    public AsciidocOptionsBuilder backend(String backend) {
        this.asciidocOptions.setBackend(backend);
        return this;
    }

    public AsciidocOptionsBuilder docType(String docType) {
        this.asciidocOptions.setDocType(docType);
        return this;
    }

    public AsciidocOptionsBuilder inPlace(boolean inPlace) {
        this.asciidocOptions.setInPlace(inPlace);
        return this;
    }

    public AsciidocOptionsBuilder headerFooter(boolean headerFooter) {
        this.asciidocOptions.setHeaderFooter(headerFooter);
        return this;
    }

    public AsciidocOptionsBuilder templateDir(File templateDir) {
        this.asciidocOptions.setTemplateDirs(templateDir.getAbsolutePath());
        return this;
    }

    public AsciidocOptionsBuilder templateDirs(File ... templateDirs) {
        for (File templateDir : templateDirs) {
            this.asciidocOptions.setTemplateDirs(templateDir.getAbsolutePath());
        }
        return this;
    }

    public AsciidocOptionsBuilder templateEngine(String templateEngine) {
        this.asciidocOptions.setTemplateEngine(templateEngine);
        return this;
    }

    public AsciidocOptionsBuilder templateCache(boolean templateCache) {
        this.asciidocOptions.setTemplateCache(templateCache);
        return this;
    }

    @Deprecated
    public AsciidocOptionsBuilder asciidocAttributes(Map<String, Object> attributes) {
        this.asciidocOptions.setAttributes(attributes);
        return this;
    }

    public AsciidocOptionsBuilder asciidocAttributes(AsciidocAttributes asciidocAttributes) {
        this.asciidocOptions.setAttributes(asciidocAttributes);
        return this;
    }

    public AsciidocOptionsBuilder toFile(File toFile) {
        this.asciidocOptions.setToFile(toFile.getPath());
        return this;
    }

    public AsciidocOptionsBuilder toStream(OutputStream toStream) {
        this.asciidocOptions.setToStream(toStream);
        return this;
    }

    public AsciidocOptionsBuilder toDir(File directory) {
        this.asciidocOptions.setToDir(directory.getAbsolutePath());
        return this;
    }

    public AsciidocOptionsBuilder mkDirs(boolean mkDirs) {
        this.asciidocOptions.setMkDirs(mkDirs);
        return this;
    }

    public AsciidocOptionsBuilder safe(AsciidocSafeMode asciidocSafeMode) {
        this.asciidocOptions.setSafe(asciidocSafeMode);
        return this;
    }

    public AsciidocOptionsBuilder sourcemap(boolean sourcemap) {
        this.asciidocOptions.setSourcemap(sourcemap);
        return this;
    }

    public AsciidocOptionsBuilder eruby(String eruby) {
        this.asciidocOptions.setEruby(eruby);
        return this;
    }

    public AsciidocOptionsBuilder catalogAssets(boolean catalogAssets) {
        this.asciidocOptions.setCatalogAssets(catalogAssets);
        return this;
    }

    public AsciidocOptionsBuilder compact(boolean compact) {
        this.asciidocOptions.setCompact(compact);
        return this;
    }

    public AsciidocOptionsBuilder parse(boolean parse) {
        this.asciidocOptions.setParse(parse);
        return this;
    }

    public AsciidocOptionsBuilder parseHeaderOnly(boolean parseHeaderOnly) {
        this.asciidocOptions.setParseHeaderOnly(parseHeaderOnly);
        return this;
    }

    public AsciidocOptionsBuilder destinationDir(File destinationDir) {
        this.asciidocOptions.setDestinationDir(destinationDir.getAbsolutePath());
        return this;
    }

    public AsciidocOptionsBuilder sourceDir(File srcDir) {
        this.asciidocOptions.setSourceDir(srcDir.getAbsolutePath());
        return this;
    }

    public AsciidocOptionsBuilder baseDir(File baseDir) {
        this.asciidocOptions.setBaseDir(baseDir.getAbsolutePath());
        return this;
    }

    public AsciidocOptions build() {
        return this.asciidocOptions;
    }

    public AsciidocOptionsBuilder customOption(String option, Object value) {
        this.asciidocOptions.setCustomOption(option, value);
        return this;
    }
}

