/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.client;

import de.jcup.asp.client.AspClientAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspClientProgressMonitorSurveillance {
    public static AspClientProgressMonitorSurveillance INSTANCE = new AspClientProgressMonitorSurveillance();
    private static final Logger LOG = LoggerFactory.getLogger(AspClientProgressMonitorSurveillance.class);
    private Thread surveillanceThread;
    private QueueRunnable queueRunnable;
    private Set<AspClientAction> aspClientActions = new LinkedHashSet<AspClientAction>();

    private AspClientProgressMonitorSurveillance() {
        this.ensureRunningClientWorkerThread();
    }

    public void ensureRunningClientWorkerThread() {
        if (this.surveillanceThread != null && this.surveillanceThread.isAlive()) {
            return;
        }
        this.queueRunnable = new QueueRunnable();
        this.surveillanceThread = new Thread((Runnable)this.queueRunnable, "ASP Client ProgressMonitor");
        this.surveillanceThread.setDaemon(true);
        this.surveillanceThread.start();
    }

    public void cancel(AspClientAction aspClientAction) {
        try {
            aspClientAction.cancel();
        }
        catch (IOException e) {
            LOG.warn("Cancel operation problematic", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspect(AspClientAction clientCall, int timeOutInMilliseconds) {
        Objects.requireNonNull(clientCall);
        Set<AspClientAction> set = this.aspClientActions;
        synchronized (set) {
            this.aspClientActions.add(clientCall);
        }
    }

    public class QueueRunnable
    implements Runnable {
        AspClientAction current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<AspClientAction> callsToRemove = new ArrayList<AspClientAction>();
            while (true) {
                Set set = AspClientProgressMonitorSurveillance.this.aspClientActions;
                synchronized (set) {
                    try {
                        for (AspClientAction call : AspClientProgressMonitorSurveillance.this.aspClientActions) {
                            if (call.getProgressMonitor().isCanceled()) {
                                callsToRemove.add(call);
                                call.cancel();
                                continue;
                            }
                            if (!call.done()) continue;
                            callsToRemove.add(call);
                        }
                        AspClientProgressMonitorSurveillance.this.aspClientActions.removeAll(callsToRemove);
                    }
                    catch (Exception e) {
                        LOG.error("Progress monitor surveillance failure", e);
                    }
                }
                this.waitShortTime();
            }
        }

        private void waitShortTime() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

