/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj.launcher;

import de.jcup.asp.core.ASPLauncher;
import de.jcup.asp.core.ExitCode;
import de.jcup.asp.core.LaunchException;
import de.jcup.asp.core.LogHandler;
import de.jcup.asp.core.OutputHandler;
import de.jcup.asp.core.ServerExitCodes;
import java.io.File;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessAsciidoctorJServerLauncher
implements ASPLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalProcessAsciidoctorJServerLauncher.class);
    private int port;
    private String pathToJavaBinary;
    private String pathToServerJar;
    private boolean showSecretKey;
    private Process process;
    private OutputHandler outputHandler;
    private LogHandler logHandler;
    private boolean showServerOutput;
    private Map<String, String> customEnvironmentEntries;

    public ExternalProcessAsciidoctorJServerLauncher(String pathToServerJar, int port) {
        this.pathToServerJar = pathToServerJar;
        this.port = port;
        this.customEnvironmentEntries = new TreeMap<String, String>();
    }

    public void setShowSecretKey(boolean showSecretKey) {
        this.showSecretKey = showSecretKey;
    }

    public void setShowServerOutput(boolean showServerOutput) {
        this.showServerOutput = showServerOutput;
    }

    public void setEnvironment(String key, String value) {
        Objects.requireNonNull(key, "Key may not be null - not acceptable.");
        this.customEnvironmentEntries.put(key, value);
    }

    @Override
    public String launch(int timeOutInSeconds) throws LaunchException {
        ServerStartRunnable runnable = new ServerStartRunnable(this.port);
        Thread thread = new Thread((Runnable)runnable, "ASP Launcher, port:" + this.port);
        thread.setDaemon(true);
        thread.start();
        this.waitForSecretKey(timeOutInSeconds, runnable);
        return runnable.secretKey;
    }

    private void waitForSecretKey(int timeOutInSeconds, ServerStartRunnable runnable) throws LaunchException {
        Duration acceptedmax = Duration.ofSeconds(timeOutInSeconds);
        Instant start = Instant.now();
        while (this.hasNotEnded() && runnable.failed == null && runnable.secretKey == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            Instant finish = Instant.now();
            Duration duration = Duration.between(start, finish);
            if (duration.compareTo(acceptedmax) <= 0) continue;
            throw new LaunchException("Timed out after " + duration.getSeconds() + " seconds");
        }
        if (runnable.failed != null) {
            throw new LaunchException("Was not able to launch server on port:" + this.port, runnable.failed);
        }
        if (runnable.secretKey == null) {
            throw new LaunchException("Server did not return secret!", null);
        }
    }

    private boolean hasNotEnded() {
        if (this.process == null) {
            return true;
        }
        return this.process.isAlive();
    }

    public int getPort() {
        return this.port;
    }

    public void setPathToJavaBinary(String pathToJavaBinary) {
        if (Objects.equals(pathToJavaBinary, this.pathToJavaBinary)) {
            return;
        }
        this.pathToJavaBinary = pathToJavaBinary;
    }

    public void setPathToServerJar(String pathToServerJar) {
        this.pathToServerJar = pathToServerJar;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public boolean stopServer() {
        if (this.process == null) {
            return false;
        }
        if (!this.process.isAlive()) {
            return false;
        }
        this.process.destroyForcibly();
        return true;
    }

    private class ServerStartRunnable
    implements Runnable {
        private String secretKey;
        private Throwable failed;
        int port;

        private ServerStartRunnable(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            String javaCommand = null;
            if (ExternalProcessAsciidoctorJServerLauncher.this.pathToJavaBinary == null || ExternalProcessAsciidoctorJServerLauncher.this.pathToJavaBinary.trim().isEmpty()) {
                javaCommand = "java";
            } else {
                javaCommand = ExternalProcessAsciidoctorJServerLauncher.this.pathToJavaBinary;
                File test = new File(javaCommand);
                if (!test.exists()) {
                    if (ExternalProcessAsciidoctorJServerLauncher.this.outputHandler != null) {
                        ExternalProcessAsciidoctorJServerLauncher.this.outputHandler.output(">> Not able to start java because not found on defined location:" + javaCommand);
                    }
                    return;
                }
                if (!test.canExecute()) {
                    if (ExternalProcessAsciidoctorJServerLauncher.this.outputHandler != null) {
                        ExternalProcessAsciidoctorJServerLauncher.this.outputHandler.output(">> Not able to start java because existing but not executable: " + javaCommand);
                    }
                    return;
                }
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(javaCommand);
            commands.add("-Dasp.server.port=" + this.port);
            commands.add("-jar");
            commands.add(ExternalProcessAsciidoctorJServerLauncher.this.pathToServerJar);
            LOG.debug("Start process with command:{}", (Object)commands);
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.redirectErrorStream(true);
            Map<String, String> environment = pb.environment();
            environment.putAll(ExternalProcessAsciidoctorJServerLauncher.this.customEnvironmentEntries);
            StringBuffer lineStringBuffer = new StringBuffer();
            try {
                ExternalProcessAsciidoctorJServerLauncher.this.process = pb.start();
                if (ExternalProcessAsciidoctorJServerLauncher.this.outputHandler != null) {
                    ExternalProcessAsciidoctorJServerLauncher.this.outputHandler.output(">> Triggered ASP server start at port:" + this.port);
                }
                try (InputStream is = ExternalProcessAsciidoctorJServerLauncher.this.process.getInputStream();){
                    int c;
                    while ((c = is.read()) != -1) {
                        if (c == 10) {
                            String line = lineStringBuffer.toString();
                            int secretPrefix = line.indexOf("Server secret :");
                            if (secretPrefix != -1) {
                                this.secretKey = line.substring(secretPrefix + "Server secret :".length()).trim();
                                if (!ExternalProcessAsciidoctorJServerLauncher.this.showSecretKey) {
                                    line = line.substring(0, secretPrefix) + "Server secret :" + "xxxxxxxxxxxxxxxxxxxxxxx";
                                }
                            }
                            if (ExternalProcessAsciidoctorJServerLauncher.this.outputHandler != null && ExternalProcessAsciidoctorJServerLauncher.this.showServerOutput) {
                                ExternalProcessAsciidoctorJServerLauncher.this.outputHandler.output(line);
                            }
                            lineStringBuffer = new StringBuffer();
                            continue;
                        }
                        lineStringBuffer.append((char)c);
                    }
                }
                if (ExternalProcessAsciidoctorJServerLauncher.this.outputHandler != null) {
                    ExternalProcessAsciidoctorJServerLauncher.this.outputHandler.output(lineStringBuffer.toString());
                }
                int exitCode = ExternalProcessAsciidoctorJServerLauncher.this.process.waitFor();
                if (ExternalProcessAsciidoctorJServerLauncher.this.outputHandler != null) {
                    ExitCode exitCodeObject = ServerExitCodes.from(exitCode);
                    ExternalProcessAsciidoctorJServerLauncher.this.outputHandler.output(">> ASP Server at port " + this.port + " exited with code:" + exitCodeObject.toMessage());
                }
            }
            catch (Exception e) {
                String message = ">> FATAL ASP server connection failure :" + e.getMessage();
                if (ExternalProcessAsciidoctorJServerLauncher.this.outputHandler != null) {
                    ExternalProcessAsciidoctorJServerLauncher.this.outputHandler.output(message);
                } else {
                    System.err.println(message);
                }
                if (ExternalProcessAsciidoctorJServerLauncher.this.logHandler != null) {
                    ExternalProcessAsciidoctorJServerLauncher.this.logHandler.error(message, e);
                }
                e.printStackTrace();
            }
        }
    }
}

