/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander.converters;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathConverter
extends BaseConverter<Path> {
    public PathConverter(String optionName) {
        super(optionName);
    }

    @Override
    public Path convert(String value2) {
        try {
            return Paths.get(value2, new String[0]);
        }
        catch (InvalidPathException e) {
            String encoded = PathConverter.escapeUnprintable(value2);
            throw new ParameterException(this.getErrorString(encoded, "a path"));
        }
    }

    private static String escapeUnprintable(String value2) {
        StringBuilder bldr = new StringBuilder();
        for (char c : value2.toCharArray()) {
            if (c < ' ') {
                bldr.append("\\u").append(String.format("%04X", c));
                continue;
            }
            bldr.append(c);
        }
        return bldr.toString();
    }
}

