/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.json;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonHandler;
import com.eclipsesource.json.JsonLiteral;
import com.eclipsesource.json.JsonNumber;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonParser;
import com.eclipsesource.json.JsonString;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.Reader;

public final class Json {
    public static final JsonValue NULL = new JsonLiteral("null");
    public static final JsonValue TRUE = new JsonLiteral("true");
    public static final JsonValue FALSE = new JsonLiteral("false");

    private Json() {
    }

    public static JsonValue value(int value2) {
        return new JsonNumber(Integer.toString(value2, 10));
    }

    public static JsonValue value(long value2) {
        return new JsonNumber(Long.toString(value2, 10));
    }

    public static JsonValue value(float value2) {
        if (Float.isInfinite(value2) || Float.isNaN(value2)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Json.cutOffPointZero(Float.toString(value2)));
    }

    public static JsonValue value(double value2) {
        if (Double.isInfinite(value2) || Double.isNaN(value2)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Json.cutOffPointZero(Double.toString(value2)));
    }

    public static JsonValue value(String string2) {
        return string2 == null ? NULL : new JsonString(string2);
    }

    public static JsonValue value(boolean value2) {
        return value2 ? TRUE : FALSE;
    }

    public static JsonArray array() {
        return new JsonArray();
    }

    public static JsonArray array(int ... values2) {
        if (values2 == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray array2 = new JsonArray();
        for (int value2 : values2) {
            array2.add(value2);
        }
        return array2;
    }

    public static JsonArray array(long ... values2) {
        if (values2 == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray array2 = new JsonArray();
        for (long value2 : values2) {
            array2.add(value2);
        }
        return array2;
    }

    public static JsonArray array(float ... values2) {
        if (values2 == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray array2 = new JsonArray();
        for (float value2 : values2) {
            array2.add(value2);
        }
        return array2;
    }

    public static JsonArray array(double ... values2) {
        if (values2 == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray array2 = new JsonArray();
        for (double value2 : values2) {
            array2.add(value2);
        }
        return array2;
    }

    public static JsonArray array(boolean ... values2) {
        if (values2 == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray array2 = new JsonArray();
        for (boolean value2 : values2) {
            array2.add(value2);
        }
        return array2;
    }

    public static JsonArray array(String ... strings) {
        if (strings == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray array2 = new JsonArray();
        for (String value2 : strings) {
            array2.add(value2);
        }
        return array2;
    }

    public static JsonObject object() {
        return new JsonObject();
    }

    public static JsonValue parse(String string2) {
        if (string2 == null) {
            throw new NullPointerException("string is null");
        }
        DefaultHandler handler = new DefaultHandler();
        new JsonParser(handler).parse(string2);
        return handler.getValue();
    }

    public static JsonValue parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        DefaultHandler handler = new DefaultHandler();
        new JsonParser(handler).parse(reader);
        return handler.getValue();
    }

    private static String cutOffPointZero(String string2) {
        if (string2.endsWith(".0")) {
            return string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultHandler
    extends JsonHandler<JsonArray, JsonObject> {
        protected JsonValue value;

        DefaultHandler() {
        }

        @Override
        public JsonArray startArray() {
            return new JsonArray();
        }

        @Override
        public JsonObject startObject() {
            return new JsonObject();
        }

        @Override
        public void endNull() {
            this.value = NULL;
        }

        @Override
        public void endBoolean(boolean bool2) {
            this.value = bool2 ? TRUE : FALSE;
        }

        @Override
        public void endString(String string2) {
            this.value = new JsonString(string2);
        }

        @Override
        public void endNumber(String string2) {
            this.value = new JsonNumber(string2);
        }

        @Override
        public void endArray(JsonArray array2) {
            this.value = array2;
        }

        @Override
        public void endObject(JsonObject object) {
            this.value = object;
        }

        @Override
        public void endArrayValue(JsonArray array2) {
            array2.add(this.value);
        }

        @Override
        public void endObjectValue(JsonObject object, String name2) {
            object.add(name2, this.value);
        }

        JsonValue getValue() {
            return this.value;
        }
    }
}

