/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.api;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Map;
import java.util.TreeMap;

public class JsonToMapBuilder {
    public Map<String, Object> toMap(JsonValue jsonValue) {
        TreeMap<String, Object> map2 = new TreeMap<String, Object>();
        if (!jsonValue.isObject()) {
            return map2;
        }
        JsonObject jsonObject = jsonValue.asObject();
        for (JsonObject.Member member : jsonObject) {
            String name2 = member.getName();
            JsonValue value2 = member.getValue();
            if (value2.isObject()) {
                map2.put(name2, this.toMap(value2));
                continue;
            }
            if (value2.isBoolean()) {
                map2.put(name2, value2.asBoolean());
                continue;
            }
            if (value2.isString()) {
                map2.put(name2, value2.asString());
                continue;
            }
            if (value2.isNull() || !value2.isNumber()) continue;
            boolean resolved = false;
            resolved = resolved || this.tryToResolveAsInteger(name2, value2, map2);
            resolved = resolved || this.tryToResolveAsLong(name2, value2, map2);
            resolved = resolved || this.tryToResolveAsFloat(name2, value2, map2);
            resolved = resolved || this.tryToResolveAsDouble(name2, value2, map2);
        }
        return map2;
    }

    private boolean tryToResolveAsFloat(String name2, JsonValue value2, Map<String, Object> map2) {
        try {
            map2.put(name2, Float.valueOf(value2.asFloat()));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean tryToResolveAsDouble(String name2, JsonValue value2, Map<String, Object> map2) {
        try {
            map2.put(name2, value2.asDouble());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean tryToResolveAsInteger(String name2, JsonValue value2, Map<String, Object> map2) {
        try {
            map2.put(name2, value2.asInt());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean tryToResolveAsLong(String name2, JsonValue value2, Map<String, Object> map2) {
        try {
            map2.put(name2, value2.asInt());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

