/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.api;

import de.jcup.asp.api.AbstractProtocolObject;
import de.jcup.asp.api.MapResponseResultKey;
import de.jcup.asp.api.ProtocolData;
import de.jcup.asp.api.ProtocolDataException;
import de.jcup.asp.api.ResponseResultKey;
import de.jcup.asp.api.ServerLog;
import de.jcup.asp.api.StringResponseResultKey;
import de.jcup.asp.api.ValueProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class Response
extends AbstractProtocolObject {
    public static final String TERMINATOR = "--RESPONSE-TERMINATE--";

    public <T> void set(ResponseResultKey<T> key2, ValueProvider<T> provider) {
        this.internalSet(key2, provider);
    }

    public void set(ResponseResultKey<String> key2, String value2) {
        this.internalSet(key2, value2);
    }

    public void setServerLog(ServerLog log3) {
        this.internalSet(StringResponseResultKey.SERVER_LOGS, log3.convertToString());
    }

    public ServerLog getServerLog() {
        String json = this.internalGetString(StringResponseResultKey.SERVER_LOGS);
        return ServerLog.convertFromString(json);
    }

    public Path getResultFilePath() {
        String filePath = this.getString(StringResponseResultKey.RESULT_FILEPATH);
        if (filePath == null) {
            return null;
        }
        Path path2 = Paths.get(filePath, new String[0]);
        return path2;
    }

    public Map<String, Object> getAttributes() {
        return this.getMap(MapResponseResultKey.RESULT_ATTRIBUTES);
    }

    public void set(ResponseResultKey<Map<String, Object>> mapKey, Map<String, Object> map2) {
        this.internalSet(mapKey, map2);
    }

    public String getString(ResponseResultKey<String> key2) {
        return this.internalGetString(key2);
    }

    public Map<String, Object> getMap(ResponseResultKey<Map<String, Object>> key2) {
        return this.internalGetMap(key2);
    }

    public static Response convertFromString(String data2) {
        Response r = new Response();
        try {
            r.data = ProtocolData.convertFromString(data2);
        }
        catch (ProtocolDataException e) {
            r.setErrorMessage(e.getMessage());
        }
        return r;
    }

    public String getErrorMessage() {
        return this.internalGetString(StringResponseResultKey.ERROR);
    }

    public boolean failed() {
        String error2 = this.getString(StringResponseResultKey.ERROR);
        return error2 != null && !error2.isEmpty();
    }

    public void setErrorMessage(String message2) {
        this.set(StringResponseResultKey.ERROR, message2);
    }
}

