/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.api;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import de.jcup.asp.api.ServerLogSeverity;
import java.io.File;
import java.util.Objects;

public class ServerLogEntry {
    private ServerLogSeverity severity;
    private String message;
    private File file;
    private int lineNumber;

    public ServerLogEntry(ServerLogSeverity severity, String message2, File file2, int lineNumber) {
        if (severity == null) {
            severity = ServerLogSeverity.UNKNOWN;
        }
        this.severity = severity;
        this.message = message2;
        if (file2 != null) {
            file2 = file2.getAbsoluteFile();
        }
        this.file = file2;
        this.lineNumber = lineNumber;
    }

    public ServerLogSeverity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public File getFile() {
        return this.file;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.file, this.lineNumber, this.message, this.severity});
    }

    public String convertToString() {
        JsonObject obj = Json.object();
        obj.add("severity", this.severity.name());
        if (this.file != null) {
            obj.add("file", this.file.getAbsolutePath());
        }
        if (this.message != null) {
            obj.add("message", this.message);
        }
        obj.add("line", this.lineNumber);
        return obj.toString();
    }

    public static ServerLogEntry convertFromString(String string2) {
        if (string2 == null || string2.trim().isEmpty()) {
            string2 = "{}";
        }
        JsonValue data2 = Json.parse(string2);
        JsonObject obj = data2.asObject();
        JsonValue filePath = obj.get("file");
        File file2 = null;
        if (filePath != null) {
            file2 = new File(filePath.asString());
        }
        int lineNumber = -1;
        JsonValue line = obj.get("line");
        if (line != null) {
            lineNumber = line.asInt();
        }
        ServerLogSeverity severity = null;
        JsonValue sever = obj.get("severity");
        if (sever != null) {
            String severityAsString = sever.asString();
            severity = ServerLogSeverity.fromString(severityAsString);
        }
        String message2 = null;
        JsonValue msg = obj.get("message");
        if (msg != null) {
            message2 = msg.asString();
        }
        ServerLogEntry entry = new ServerLogEntry(severity, message2, file2, lineNumber);
        return entry;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerLogEntry)) {
            return false;
        }
        ServerLogEntry other = (ServerLogEntry)obj;
        return Objects.equals(this.file, other.file) && this.lineNumber == other.lineNumber && Objects.equals(this.message, other.message) && this.severity == other.severity;
    }

    public String toString() {
        return "ServerLogEntry [severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ", file=" + this.file + ", lineNumber=" + this.lineNumber + "]";
    }
}

