/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.core;

import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptoAccess {
    private static final String SECURITY_ALGORITHM = "AES";
    private static KeyGenerator keyGen;
    private SecretKey secretKey;

    public CryptoAccess() {
        this.secretKey = CryptoAccess.getkeyGen(SECURITY_ALGORITHM).generateKey();
    }

    public CryptoAccess(String base64encodedSecretKey) {
        byte[] decodedKey = Base64.getDecoder().decode(base64encodedSecretKey);
        this.secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, SECURITY_ALGORITHM);
    }

    public String getSecretKey() {
        String encodedKey = Base64.getEncoder().encodeToString(this.secretKey.getEncoded());
        return encodedKey;
    }

    private static KeyGenerator getkeyGen(String algorithm) {
        if (keyGen != null) {
            return keyGen;
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
            keyGen.init(128);
            CryptoAccess.keyGen = keyGen;
            return CryptoAccess.keyGen;
        }
        catch (Exception e) {
            throw new IllegalStateException("FATAL:cannot create key generator", e);
        }
    }

    public String encrypt(String strToEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance(SECURITY_ALGORITHM);
            cipher.init(1, (Key)this.secretKey, new SecureRandom());
            byte[] encryptedBytes = cipher.doFinal(strToEncrypt.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(encryptedBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot encrypt given string", e);
        }
    }

    public String decrypt(String strToDecrypt) throws DecryptionException {
        try {
            Cipher cipher = Cipher.getInstance(SECURITY_ALGORITHM);
            cipher.init(2, this.secretKey);
            byte[] base64ToDecrypt = Base64.getDecoder().decode(strToDecrypt);
            byte[] decryptedBytes = cipher.doFinal(base64ToDecrypt);
            return new String(decryptedBytes, "UTF-8");
        }
        catch (Exception e) {
            if (e instanceof BadPaddingException) {
                throw new DecryptionException("Decryption failed, bad key", e);
            }
            throw new IllegalStateException("cannot decrypt given string", e);
        }
    }

    public class DecryptionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DecryptionException(String message2, Throwable t) {
            super(message2, t);
        }
    }
}

