/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj;

import de.jcup.asp.core.ServerExitCodes;
import de.jcup.asp.server.asciidoctorj.AsciidoctorJServer;
import java.net.BindException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidoctorJServerApplication {
    private static final String SYSTEM_PROPERTY__ASP_SERVER_PORT = "asp.server.port";
    private static final Logger LOG = LoggerFactory.getLogger(AsciidoctorJServerApplication.class);

    public static void main(String[] args2) {
        String portProperty = System.getProperty(SYSTEM_PROPERTY__ASP_SERVER_PORT);
        int port = -1;
        try {
            if (portProperty != null) {
                port = Integer.parseInt(portProperty);
            }
        }
        catch (NumberFormatException e) {
            port = 4444;
            LOG.error("Wrong port definition:{} using default:{}", (Object)portProperty, (Object)port);
        }
        AsciidoctorJServer server = new AsciidoctorJServer();
        try {
            server.start(port);
        }
        catch (BindException be) {
            if (port == -1) {
                LOG.error("Already bind port:{}", (Object)port);
            }
            AsciidoctorJServerApplication.exit(ServerExitCodes.ERROR_PORT_ALREADY_USED);
        }
        catch (Exception e) {
            LOG.error("Server cannot be started", e);
            AsciidoctorJServerApplication.exit(ServerExitCodes.ERROR);
        }
    }

    private static void exit(ServerExitCodes error2) {
        System.exit(error2.getExitCode());
    }
}

