/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj;

import de.jcup.asp.core.ASPLauncher;
import de.jcup.asp.core.LaunchException;
import de.jcup.asp.server.asciidoctorj.AsciidoctorJServer;

public class EmbeddedAsciidoctorJServerLauncher
implements ASPLauncher {
    private AsciidoctorJServer server = this.createServer();

    protected AsciidoctorJServer createServer() {
        return new AsciidoctorJServer();
    }

    public void stopServer() {
        this.server.coreAspServer.stop();
    }

    @Override
    public String launch(int port) throws LaunchException {
        EmbeddedServerRunnable r = new EmbeddedServerRunnable(port);
        Thread t = new Thread((Runnable)r, "Embedded ASP Server");
        t.start();
        String key2 = this.waitFortSecretKey();
        while (r.failure == null && !this.server.coreAspServer.isReady()) {
            this.wait500Millis();
        }
        if (r.failure != null) {
            throw new LaunchException("Was not able to launch ASP server", r.failure);
        }
        return key2;
    }

    private String waitFortSecretKey() {
        int maxLoops = 10;
        int loop2 = 0;
        while (this.server == null) {
            if (++loop2 > maxLoops) {
                throw new IllegalStateException("Server failure-no secret created");
            }
            this.wait500Millis();
        }
        return this.server.coreAspServer.getCryptoAccess().getSecretKey();
    }

    private void wait500Millis() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class EmbeddedServerRunnable
    implements Runnable {
        private Exception failure;
        private int port;

        private EmbeddedServerRunnable(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            try {
                EmbeddedAsciidoctorJServerLauncher.this.server.start(this.port);
            }
            catch (Exception e) {
                this.failure = e;
            }
        }
    }
}

