/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj.provider;

import de.jcup.asp.api.ServerLog;
import de.jcup.asp.api.ServerLogEntry;
import de.jcup.asp.api.ServerLogSeverity;
import java.io.File;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDataProvider
implements LogHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LogDataProvider.class);
    private ServerLog serverLog = new ServerLog();
    private Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(LogRecord logRecord) {
        ServerLogEntry logEntry = this.convert(logRecord);
        Object object = this.monitor;
        synchronized (object) {
            this.serverLog.add(logEntry);
            LOG.debug("Added log entry {}", (Object)logEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerLog getLogData() {
        ServerLog result2;
        Object object = this.monitor;
        synchronized (object) {
            result2 = this.serverLog;
            this.serverLog = new ServerLog();
        }
        return result2;
    }

    private ServerLogEntry convert(LogRecord logRecord) {
        String filePath;
        Severity logSeverity = logRecord.getSeverity();
        ServerLogSeverity severity = null;
        if (logSeverity != null) {
            severity = ServerLogSeverity.fromString(logSeverity.name());
        }
        int lineNumber = -1;
        Cursor cursor = logRecord.getCursor();
        if (cursor != null) {
            lineNumber = cursor.getLineNumber();
        }
        File file2 = null;
        if (cursor != null && (filePath = cursor.getFile()) != null) {
            file2 = new File(filePath);
        }
        String message2 = logRecord.getMessage();
        ServerLogEntry logEntry = new ServerLogEntry(severity, message2, file2, lineNumber);
        return logEntry;
    }
}

