/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj.service;

import de.jcup.asp.api.Backend;
import de.jcup.asp.server.asciidoctorj.provider.LogDataProvider;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidoctorService {
    private static final Logger LOG = LoggerFactory.getLogger(AsciidoctorService.class);
    private Asciidoctor asciidoctor;
    private LogDataProvider logDataProvider = new LogDataProvider();
    public static final AsciidoctorService INSTANCE = new AsciidoctorService();

    private AsciidoctorService() {
        LOG.info("Starting, will create asciidoctorj instance");
        this.asciidoctor = Asciidoctor.Factory.create();
        this.asciidoctor.registerLogHandler(this.logDataProvider);
        LOG.info("Created instance");
    }

    public Asciidoctor getAsciidoctor() {
        return this.asciidoctor;
    }

    public LogDataProvider getLogDataProvider() {
        return this.logDataProvider;
    }

    public void warmUp() {
        LOG.info("Starting warmup phase for asciidoctor");
        this.asciidoctor.requireLibrary("asciidoctor-diagram");
        String asciidocContent = "== Just a warmup\nThis ensures asciidoctor is running and next call is faster and does not wait for warmup phase done";
        this.asciidoctor.convert(asciidocContent, Options.builder().attributes(Attributes.builder().build()).backend(Backend.HTML.convertToString()).safe(SafeMode.UNSAFE).build());
        LOG.info("Warmup HTML done");
    }
}

