/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj.service;

import de.jcup.asp.api.Backend;
import de.jcup.asp.api.MapRequestParameterKey;
import de.jcup.asp.api.Request;
import de.jcup.asp.server.asciidoctorj.service.ConversionContext;
import de.jcup.asp.server.asciidoctorj.service.RequestAndEnvironmentAttributeProvider;
import java.util.Map;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConversionContextFactory.class);
    private RequestAndEnvironmentAttributeProvider attributeProvider;

    public ConversionContextFactory(RequestAndEnvironmentAttributeProvider attributeProvider) {
        this.attributeProvider = attributeProvider;
    }

    public ConversionContext createConversionContext(Request request) {
        Attributes attributes = this.attributeProvider.getAttributes(request);
        Map<String, Object> optionsAsMap = request.getMap(MapRequestParameterKey.OPTIONS);
        LOG.debug("AsciidocOptions:{}", (Object)optionsAsMap);
        OptionsBuilder optionsBuilder = this.createOptionsBuilderWithOptionsSet(optionsAsMap);
        Backend backend = this.resolveBackend(optionsAsMap);
        optionsBuilder.backend(backend.convertToString());
        optionsBuilder.attributes(attributes);
        ConversionContext data2 = new ConversionContext();
        data2.options = optionsBuilder.build();
        data2.options.setAttributes(attributes);
        data2.backend = backend;
        return data2;
    }

    private OptionsBuilder createOptionsBuilderWithOptionsSet(Map<String, Object> optionsAsMap) {
        OptionsBuilder optionsBuilder = Options.builder();
        for (String option : optionsAsMap.keySet()) {
            Object value2 = optionsAsMap.get(option);
            optionsBuilder.option(option, value2);
        }
        return optionsBuilder;
    }

    private Backend resolveBackend(Map<String, Object> optionsAsMap) {
        Object backendOption = optionsAsMap.get(Backend.getOptionId());
        Backend backend = null;
        backend = backendOption instanceof String ? Backend.convertFromString(backendOption.toString()) : Backend.getDefault();
        return backend;
    }
}

