/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj.service;

import de.jcup.asp.api.Request;
import de.jcup.asp.api.Response;
import de.jcup.asp.api.StringRequestParameterKey;
import de.jcup.asp.api.StringResponseResultKey;
import de.jcup.asp.server.asciidoctorj.provider.TargetFileNameProvider;
import de.jcup.asp.server.asciidoctorj.service.AsciidoctorService;
import de.jcup.asp.server.asciidoctorj.service.ConversionContext;
import de.jcup.asp.server.asciidoctorj.service.ConversionContextFactory;
import de.jcup.asp.server.asciidoctorj.service.ConvertLocalFileService;
import de.jcup.asp.server.asciidoctorj.service.RequestAndEnvironmentAttributeProvider;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.asciidoctor.Asciidoctor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertLocalFileServiceImpl
implements ConvertLocalFileService {
    public static final ConvertLocalFileService INSTANCE = new ConvertLocalFileServiceImpl();
    private static final Logger LOG = LoggerFactory.getLogger(ConvertLocalFileServiceImpl.class);
    TargetFileNameProvider targetFileNameProvider;
    ConversionContextFactory conversionContextFactory;
    AsciidoctorService service = AsciidoctorService.INSTANCE;

    ConvertLocalFileServiceImpl() {
        this.targetFileNameProvider = new TargetFileNameProvider();
        this.conversionContextFactory = new ConversionContextFactory(new RequestAndEnvironmentAttributeProvider());
    }

    @Override
    public void convertFile(Request request, Response response) {
        try {
            this.handleConvert(request, response);
        }
        catch (Exception e) {
            LOG.error("Was not able to convert", e);
            response.setErrorMessage(e.getMessage());
        }
    }

    private void handleConvert(Request request, Response response) throws Exception {
        String filePath = request.getString(StringRequestParameterKey.SOURCE_FILEPATH);
        Objects.requireNonNull(filePath, "File path must be set!");
        Asciidoctor asciidoctor = this.service.getAsciidoctor();
        Path adocfile = Paths.get(filePath, new String[0]);
        ConversionContext conversionContext = this.conversionContextFactory.createConversionContext(request);
        asciidoctor.convertFile(adocfile.toFile(), conversionContext.options);
        File targetFile = this.targetFileNameProvider.resolveTargetFileFor(adocfile.toFile(), conversionContext.backend);
        response.set(StringResponseResultKey.RESULT_FILEPATH, targetFile.getAbsolutePath());
        response.setServerLog(this.service.getLogDataProvider().getLogData());
    }
}

