/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.server.asciidoctorj.service;

import de.jcup.asp.api.MapRequestParameterKey;
import de.jcup.asp.api.Request;
import de.jcup.asp.api.asciidoc.AsciidocAttribute;
import java.util.Map;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAndEnvironmentAttributeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAndEnvironmentAttributeProvider.class);

    public Attributes getAttributes(Request request) {
        Map<String, Object> attributesAsMap = request.getMap(MapRequestParameterKey.ATTRIBUTES);
        LOG.debug("AsciidocAttributes:{}", (Object)attributesAsMap);
        AttributesBuilder attributesBuilder = this.createAttributesBuilderWithAttributesSet(attributesAsMap);
        this.addAttributesByEnvironment(attributesBuilder);
        Attributes attributes = attributesBuilder.build();
        return attributes;
    }

    private void addAttributesByEnvironment(AttributesBuilder attributesBuilder) {
        String graphvizDot = System.getenv("GRAPHVIZ_DOT");
        if (graphvizDot != null) {
            attributesBuilder.attribute("graphvizdot@", graphvizDot);
        }
    }

    private AttributesBuilder createAttributesBuilderWithAttributesSet(Map<String, Object> attributesAsMap) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (String attribute : attributesAsMap.keySet()) {
            boolean unknownAttribute = true;
            for (AsciidocAttribute wellknown : AsciidocAttribute.values()) {
                if (!wellknown.getKey().equals(attribute)) continue;
                unknownAttribute = false;
                break;
            }
            if (unknownAttribute) {
                LOG.warn("unknown attribute used in request:{}", (Object)attribute);
            }
            Object value2 = attributesAsMap.get(attribute);
            attributesBuilder.attribute(attribute, value2);
        }
        return attributesBuilder;
    }
}

