/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Author;
import org.asciidoctor.ast.DocumentHeader;
import org.asciidoctor.ast.RevisionInfo;
import org.asciidoctor.ast.Title;
import org.asciidoctor.jruby.ast.impl.RevisionInfoImpl;
import org.asciidoctor.jruby.internal.CaseInsensitiveMap;

public class DocumentHeaderImpl
implements DocumentHeader {
    private Title documentTitle;
    private String pageTitle;
    private List<Author> authors;
    private RevisionInfo revisionInfo;
    private Map<String, Object> attributes;

    private DocumentHeaderImpl() {
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public Title getDocumentTitle() {
        return this.documentTitle;
    }

    @Override
    public String getPageTitle() {
        return this.pageTitle;
    }

    @Override
    public Author getAuthor() {
        return this.authors == null || this.authors.size() == 0 ? null : this.authors.get(0);
    }

    @Override
    public RevisionInfo getRevisionInfo() {
        return this.revisionInfo;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static DocumentHeaderImpl createDocumentHeader(Title documentTitle, String pageTitle, List<Author> authors, Map<String, Object> attributes) {
        DocumentHeaderImpl documentHeader = new DocumentHeaderImpl();
        documentHeader.documentTitle = documentTitle;
        documentHeader.pageTitle = pageTitle;
        documentHeader.attributes = new CaseInsensitiveMap<String, Object>(attributes);
        documentHeader.authors = authors;
        documentHeader.revisionInfo = DocumentHeaderImpl.getRevisionInfo(attributes);
        return documentHeader;
    }

    private static RevisionInfo getRevisionInfo(Map<String, Object> attributes) {
        return RevisionInfoImpl.getInstance(attributes);
    }
}

