/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.extension.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.DescriptionList;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.PhraseNode;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Processor;
import org.asciidoctor.extension.Reader;
import org.asciidoctor.jruby.ast.impl.ColumnImpl;
import org.asciidoctor.jruby.ast.impl.ContentNodeImpl;
import org.asciidoctor.jruby.ast.impl.DescriptionListImpl;
import org.asciidoctor.jruby.ast.impl.DocumentImpl;
import org.asciidoctor.jruby.ast.impl.ListImpl;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.asciidoctor.jruby.ast.impl.RowImpl;
import org.asciidoctor.jruby.ast.impl.StructuralNodeImpl;
import org.asciidoctor.jruby.extension.internal.ReaderImpl;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.asciidoctor.jruby.internal.JRubyRuntimeContext;
import org.asciidoctor.jruby.internal.RubyHashUtil;
import org.asciidoctor.jruby.internal.RubyObjectWrapper;
import org.asciidoctor.jruby.internal.RubyUtils;
import org.asciidoctor.log.LogRecord;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyProcessor
implements Processor {
    private JRubyAsciidoctor asciidoctor;
    public static final String CONTENT_MODEL_EMPTY = ":empty";
    protected Map<String, Object> config;
    private boolean configFinalized = false;

    public JRubyProcessor() {
        this(new HashMap<String, Object>());
    }

    public JRubyProcessor(Map<String, Object> config) {
        this.config = new HashMap<String, Object>(config);
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public final void setConfig(Map<String, Object> config) {
        if (this.configFinalized) {
            throw new IllegalStateException("It is only allowed to set the config in the constructor!");
        }
        this.config = config;
    }

    @Override
    public final void updateConfig(Map<String, Object> config) {
        this.config.putAll(config);
    }

    public final void setConfigFinalized() {
        this.configFinalized = true;
    }

    @Override
    public Table createTable(StructuralNode parent) {
        return this.createTable(parent, new HashMap<String, Object>());
    }

    @Override
    public Table createTable(StructuralNode parent, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash rubyAttributes = RubyHash.newHash(rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters2 = new IRubyObject[]{((StructuralNodeImpl)parent).getRubyObject(), rubyAttributes};
        Table ret = (Table)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_CLASS, parameters2);
        ret.setAttribute("rowcount", 0, false);
        return ret;
    }

    @Override
    public Row createTableRow(Table parent) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyArray rubyRow = rubyRuntime.newArray();
        return new RowImpl(rubyRow);
    }

    @Override
    public Column createTableColumn(Table parent, int index2, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash rubyAttributes = RubyHash.newHash(rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters2 = new IRubyObject[]{((StructuralNodeImpl)((Object)parent)).getRubyObject(), RubyFixnum.newFixnum(rubyRuntime, index2), rubyAttributes};
        return (Column)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_COLUMN_CLASS, parameters2);
    }

    @Override
    public Cell createTableCell(Column column2, Document innerDocument, Map<String, Object> attributes) {
        Cell cell = this.createTableCell(column2, (String)null, attributes);
        cell.setStyle("asciidoc");
        cell.setInnerDocument(innerDocument);
        return cell;
    }

    @Override
    public Cell createTableCell(Column column2, String text, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(column2);
        RubyHash rubyAttributes = RubyHash.newHash(rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters2 = new IRubyObject[]{((ColumnImpl)column2).getRubyObject(), text != null ? rubyRuntime.newString(text) : rubyRuntime.getNil(), rubyAttributes};
        return (Cell)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_CELL_CLASS, parameters2);
    }

    @Override
    public Block createBlock(StructuralNode parent, String context, String content, Map<String, Object> attributes, Map<Object, Object> options2) {
        options2.put("source", content);
        options2.put("attributes", attributes);
        return this.createBlock(parent, context, options2);
    }

    @Override
    public Block createBlock(StructuralNode parent, String context, List<String> content, Map<String, Object> attributes, Map<Object, Object> options2) {
        options2.put("source", content);
        options2.put("attributes", new HashMap<String, Object>(attributes));
        return this.createBlock(parent, context, options2);
    }

    @Override
    public PhraseNode createPhraseNode(ContentNode parent, String context, List<String> text, Map<String, Object> attributes, Map<Object, Object> options2) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        options2.put("attributes", attributes);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, options2);
        RubyArray rubyText = rubyRuntime.newArray();
        rubyText.addAll(text);
        IRubyObject[] parameters2 = new IRubyObject[]{((ContentNodeImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), rubyText, convertMapToRubyHashWithSymbols};
        return (PhraseNode)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.INLINE_CLASS, parameters2);
    }

    @Override
    public PhraseNode createPhraseNode(ContentNode parent, String context, String text, Map<String, Object> attributes, Map<String, Object> options2) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        options2.put("attributes", RubyHashUtil.convertMapToRubyHashWithStrings(rubyRuntime, attributes));
        RubyHash convertedOptions = RubyHashUtil.convertMapToRubyHashWithSymbols(rubyRuntime, options2);
        IRubyObject[] parameters2 = new IRubyObject[]{((ContentNodeImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), text == null ? rubyRuntime.getNil() : rubyRuntime.newString(text), convertedOptions};
        return (PhraseNode)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.INLINE_CLASS, parameters2);
    }

    @Override
    public Block createBlock(StructuralNode parent, String context, Map<Object, Object> options2) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, this.filterBlockOptions(parent, options2, "subs", "content_model"));
        IRubyObject[] parameters2 = new IRubyObject[]{((StructuralNodeImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), convertMapToRubyHashWithSymbols};
        return (Block)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.BLOCK_CLASS, parameters2);
    }

    private Map<Object, Object> filterBlockOptions(StructuralNode parent, Map<Object, Object> options2, String ... optionNames) {
        HashMap<Object, Object> copy = new HashMap<Object, Object>(options2);
        Ruby ruby = JRubyRuntimeContext.get(parent);
        for (String optionName : optionNames) {
            Object optionValue = copy.get(optionName);
            if (optionValue == null) continue;
            if (optionValue instanceof String) {
                copy.put(optionName, this.getRubySymbol(ruby, (String)optionValue));
                continue;
            }
            if (!(optionValue instanceof List)) continue;
            List valueList = (List)optionValue;
            ArrayList<RubySymbol> newValueList = new ArrayList<RubySymbol>(valueList.size());
            for (Object v : valueList) {
                if (v instanceof String) {
                    newValueList.add(this.getRubySymbol(ruby, (String)v));
                    continue;
                }
                newValueList.add((RubySymbol)v);
            }
            copy.put(optionName, newValueList);
        }
        return copy;
    }

    private RubySymbol getRubySymbol(Ruby ruby, String s2) {
        return ruby.newSymbol(s2.startsWith(":") ? s2.substring(1) : s2);
    }

    @Override
    public Section createSection(StructuralNode parent, Integer level2, boolean numbered, Map<Object, Object> options2) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, options2);
        IRubyObject[] parameters2 = new IRubyObject[]{((StructuralNodeImpl)parent).getRubyObject(), level2 == null ? rubyRuntime.getNil() : rubyRuntime.newFixnum(level2), rubyRuntime.newBoolean(numbered), convertMapToRubyHashWithSymbols};
        return (Section)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.SECTION_CLASS, parameters2);
    }

    @Override
    public Document createDocument(Document parentDocument) {
        Ruby runtime2 = JRubyRuntimeContext.get(parentDocument);
        RubyHash options2 = RubyHash.newHash(runtime2);
        options2.put(runtime2.newSymbol("parent"), ((DocumentImpl)parentDocument).getRubyObject());
        return (Document)NodeConverter.createASTNode(runtime2, NodeConverter.NodeType.DOCUMENT_CLASS, runtime2.getNil(), options2);
    }

    @Override
    public org.asciidoctor.ast.List createList(StructuralNode parent, String context) {
        return this.createList(parent, context, new HashMap<String, Object>(), new HashMap<Object, Object>());
    }

    @Override
    public org.asciidoctor.ast.List createList(StructuralNode parent, String context, Map<String, Object> attributes, Map<Object, Object> options2) {
        options2.put("attributes", new HashMap<String, Object>(attributes));
        return this.createList(parent, context, options2);
    }

    @Override
    public org.asciidoctor.ast.List createList(StructuralNode parent, String context, Map<Object, Object> options2) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, this.filterBlockOptions(parent, options2, "subs", "content_model"));
        IRubyObject[] parameters2 = new IRubyObject[]{((StructuralNodeImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), convertMapToRubyHashWithSymbols};
        return (org.asciidoctor.ast.List)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.LIST_CLASS, parameters2);
    }

    @Override
    public ListItem createListItem(org.asciidoctor.ast.List parent, String text) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        return (ListItem)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.LIST_ITEM_CLASS, ((ListImpl)ListImpl.class.cast(parent)).getRubyObject(), rubyRuntime.newString(text));
    }

    @Override
    public ListItem createListItem(DescriptionList parent, String text) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        return (ListItem)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.LIST_ITEM_CLASS, ((DescriptionListImpl)DescriptionListImpl.class.cast(parent)).getRubyObject(), rubyRuntime.newString(text));
    }

    @Override
    public void parseContent(StructuralNode parent, List<String> lines2) {
        Ruby runtime2 = JRubyRuntimeContext.get(parent);
        Parser parser = new Parser(runtime2, parent, ReaderImpl.createReader(runtime2, lines2));
        StructuralNode nextBlock = parser.nextBlock();
        while (nextBlock != null) {
            parent.append(nextBlock);
            nextBlock = parser.nextBlock();
        }
    }

    @Override
    public Column createTableColumn(Table parent, int index2) {
        return this.createTableColumn(parent, index2, new HashMap<String, Object>());
    }

    @Override
    public Cell createTableCell(Column column2, String text) {
        return this.createTableCell(column2, text, new HashMap<String, Object>());
    }

    @Override
    public Cell createTableCell(Column column2, Document innerDocument) {
        return this.createTableCell(column2, innerDocument, new HashMap<String, Object>());
    }

    @Override
    public Block createBlock(StructuralNode parent, String context, String content) {
        return this.createBlock(parent, context, content, new HashMap<String, Object>(), new HashMap<Object, Object>());
    }

    @Override
    public Block createBlock(StructuralNode parent, String context, String content, Map<String, Object> attributes) {
        return this.createBlock(parent, context, content, attributes, new HashMap<Object, Object>());
    }

    @Override
    public Block createBlock(StructuralNode parent, String context, List<String> content) {
        return this.createBlock(parent, context, content, new HashMap<String, Object>(), new HashMap<Object, Object>());
    }

    @Override
    public Block createBlock(StructuralNode parent, String context, List<String> content, Map<String, Object> attributes) {
        return this.createBlock(parent, context, content, attributes, new HashMap<Object, Object>());
    }

    @Override
    public Section createSection(StructuralNode parent) {
        return this.createSection(parent, null, true, new HashMap<Object, Object>());
    }

    @Override
    public Section createSection(StructuralNode parent, Map<Object, Object> options2) {
        return this.createSection(parent, null, true, options2);
    }

    @Override
    public Section createSection(StructuralNode parent, boolean numbered, Map<Object, Object> options2) {
        return this.createSection(parent, null, numbered, options2);
    }

    @Override
    public Section createSection(StructuralNode parent, int level2, boolean numbered, Map<Object, Object> options2) {
        return this.createSection(parent, (Integer)level2, numbered, options2);
    }

    @Override
    public PhraseNode createPhraseNode(ContentNode parent, String context, List<String> text) {
        return this.createPhraseNode(parent, context, text, new HashMap<String, Object>());
    }

    @Override
    public PhraseNode createPhraseNode(ContentNode parent, String context, List<String> text, Map<String, Object> attributes) {
        return this.createPhraseNode(parent, context, text, attributes, new HashMap<Object, Object>());
    }

    @Override
    public PhraseNode createPhraseNode(ContentNode parent, String context, String text) {
        return this.createPhraseNode(parent, context, text, new HashMap<String, Object>());
    }

    @Override
    public PhraseNode createPhraseNode(ContentNode parent, String context, String text, Map<String, Object> attributes) {
        return this.createPhraseNode(parent, context, text, attributes, new HashMap<String, Object>());
    }

    public JRubyAsciidoctor getAsciidoctor() {
        return this.asciidoctor;
    }

    public void setAsciidoctor(JRubyAsciidoctor asciidoctor) {
        this.asciidoctor = asciidoctor;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(JRubyProcessor.class)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(JRubyAsciidoctor.class)) {
            return clazz.cast(this.asciidoctor);
        }
        throw new IllegalArgumentException("Cannot unwrap to " + clazz);
    }

    @Override
    public void log(LogRecord logRecord) {
        this.unwrap(JRubyAsciidoctor.class).log(logRecord);
    }

    private class Parser
    extends RubyObjectWrapper {
        private final Reader reader;
        private final StructuralNode parent;

        public Parser(Ruby runtime2, StructuralNode parent, Reader reader) {
            super(runtime2.getModule("Asciidoctor").getClass("Parser"));
            this.reader = reader;
            this.parent = parent;
        }

        public StructuralNode nextBlock() {
            if (!this.reader.hasMoreLines()) {
                return null;
            }
            IRubyObject nextBlock = this.getRubyProperty("next_block", this.reader, ((StructuralNodeImpl)this.parent).getRubyObject());
            if (nextBlock.isNil()) {
                return null;
            }
            return (StructuralNode)NodeConverter.createASTNode(nextBlock);
        }
    }
}

