/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.extension.internal;

import java.util.List;
import org.asciidoctor.extension.Reader;
import org.asciidoctor.jruby.internal.RubyObjectWrapper;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.runtime.builtin.IRubyObject;

public class ReaderImpl
extends RubyObjectWrapper
implements Reader {
    public ReaderImpl(IRubyObject rubyNode) {
        super(rubyNode);
    }

    static ReaderImpl createReader(Ruby runtime2, List<String> lines2) {
        RubyArray rubyLines = runtime2.newArray(lines2.size());
        for (String line : lines2) {
            rubyLines.add(runtime2.newString(line));
        }
        RubyClass readerClass = runtime2.getModule("Asciidoctor").getClass("Reader");
        return new ReaderImpl(readerClass.callMethod("new", (IRubyObject)rubyLines));
    }

    @Override
    @Deprecated
    public int getLineno() {
        return this.getLineNumber();
    }

    @Override
    public int getLineNumber() {
        return this.getInt("lineno", new Object[0]);
    }

    @Override
    public String getFile() {
        IRubyObject rObj = this.getRubyProperty("file", new Object[0]);
        return rObj.toString();
    }

    @Override
    public String getDir() {
        IRubyObject rObj = this.getRubyProperty("dir", new Object[0]);
        return rObj.toString();
    }

    @Override
    public boolean hasMoreLines() {
        return this.getBoolean("has_more_lines?", new Object[0]);
    }

    @Override
    public boolean isNextLineEmpty() {
        return this.getBoolean("next_line_empty?", new Object[0]);
    }

    @Override
    public String read() {
        return this.getString("read", new Object[0]);
    }

    @Override
    public List<String> readLines() {
        return this.getList("read_lines", String.class, new Object[0]);
    }

    @Override
    public String readLine() {
        return this.getString("read_line", new Object[0]);
    }

    @Override
    public List<String> lines() {
        return this.getList("lines", String.class, new Object[0]);
    }

    @Override
    public void restoreLine(String line) {
        this.getRubyProperty("unshift_line", line);
    }

    @Override
    public void restoreLines(List<String> lines2) {
        this.getRubyProperty("unshift_lines", lines2);
    }

    @Override
    public String peekLine() {
        return this.getString("peek_line", new Object[0]);
    }

    @Override
    public List<String> peekLines(int lineCount) {
        return this.getList("peek_lines", String.class, lineCount);
    }

    @Override
    public boolean advance() {
        return this.getBoolean("advance", new Object[0]);
    }

    @Override
    public void terminate() {
        this.getRubyProperty("terminate", new Object[0]);
    }
}

