/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.log.internal;

import java.util.Objects;
import java.util.Optional;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.jruby.ast.impl.CursorImpl;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaLogger
extends RubyObject {
    private final LogHandler rootLogHandler;
    private static final String LOG_PROPERTY_SOURCE_LOCATION = "source_location";
    private static final String LOG_PROPERTY_TEXT = "text";

    public static void install(Ruby runtime2, final LogHandler logHandler) {
        RubyModule asciidoctorModule = runtime2.getModule("Asciidoctor");
        RubyModule loggerManager = asciidoctorModule.defineOrGetModuleUnder("LoggerManager");
        RubyClass loggerBaseClass = asciidoctorModule.getClass("Logger");
        RubyClass loggerClass = asciidoctorModule.defineOrGetModuleUnder("LoggerManager").defineClassUnder("JavaLogger", loggerBaseClass, new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new JavaLogger(runtime2, klazz, logHandler);
            }
        });
        loggerClass.defineAnnotatedMethods(JavaLogger.class);
        IRubyObject logger = loggerClass.allocate();
        logger.callMethod(runtime2.getCurrentContext(), "initialize", runtime2.getNil());
        loggerManager.callMethod("logger=", logger);
    }

    private JavaLogger(Ruby runtime2, RubyClass metaClass, LogHandler rootLogHandler) {
        super(runtime2, metaClass);
        this.rootLogHandler = rootLogHandler;
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=2)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] args2) {
        return Helpers.invokeSuper(threadContext, (IRubyObject)this, (RubyModule)this.getMetaClass(), "initialize", args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"add"}, required=1, optional=2)
    public IRubyObject add(ThreadContext threadContext, IRubyObject[] args2, Block block) {
        IRubyObject rubyMessage = args2.length >= 2 && !args2[1].isNil() ? args2[1] : (block.isGiven() ? block.yield(threadContext, this.getRuntime().getNil()) : args2[2]);
        Cursor cursor = this.getSourceLocation(rubyMessage);
        String message2 = this.formatMessage(rubyMessage);
        Severity severity = this.mapRubyLogLevel(args2[0]);
        LogRecord record = this.createLogRecord(threadContext, severity, cursor, message2);
        this.rootLogHandler.log(record);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"fatal"}, required=0, optional=2)
    public IRubyObject fatal(ThreadContext threadContext, IRubyObject[] args2, Block block) {
        return this.log(threadContext, args2, block, Severity.FATAL);
    }

    @JRubyMethod(name={"fatal?"})
    public IRubyObject fatal(ThreadContext threadContext) {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"error"}, required=0, optional=2)
    public IRubyObject error(ThreadContext threadContext, IRubyObject[] args2, Block block) {
        return this.log(threadContext, args2, block, Severity.ERROR);
    }

    @JRubyMethod(name={"error?"})
    public IRubyObject error(ThreadContext threadContext) {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"warn"}, required=0, optional=2)
    public IRubyObject warn(ThreadContext threadContext, IRubyObject[] args2, Block block) {
        return this.log(threadContext, args2, block, Severity.WARN);
    }

    @JRubyMethod(name={"warn?"})
    public IRubyObject warn(ThreadContext threadContext) {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"info"}, required=0, optional=2)
    public IRubyObject info(ThreadContext threadContext, IRubyObject[] args2, Block block) {
        return this.log(threadContext, args2, block, Severity.INFO);
    }

    @JRubyMethod(name={"info?"})
    public IRubyObject info(ThreadContext threadContext) {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"debug"}, required=0, optional=2)
    public IRubyObject debug(ThreadContext threadContext, IRubyObject[] args2, Block block) {
        return this.log(threadContext, args2, block, Severity.DEBUG);
    }

    @JRubyMethod(name={"debug?"})
    public IRubyObject debug(ThreadContext threadContext) {
        return this.getRuntime().getTrue();
    }

    private IRubyObject log(ThreadContext threadContext, IRubyObject[] args2, Block block, Severity severity) {
        IRubyObject rubyMessage = block.isGiven() ? block.yield(threadContext, this.getRuntime().getNil()) : args2[0];
        Cursor cursor = this.getSourceLocation(rubyMessage);
        String message2 = this.formatMessage(rubyMessage);
        LogRecord record = this.createLogRecord(threadContext, severity, cursor, message2);
        this.rootLogHandler.log(record);
        return this.getRuntime().getNil();
    }

    private LogRecord createLogRecord(ThreadContext threadContext, Severity severity, Cursor cursor, String message2) {
        Optional<BacktraceElement> elem = threadContext.getBacktrace(0).skip(1L).findFirst();
        String sourceFileName = elem.map(BacktraceElement::getFilename).orElse(null);
        String sourceMethodName = elem.map(BacktraceElement::getMethod).orElse(null);
        LogRecord record = new LogRecord(severity, cursor, message2, sourceFileName, sourceMethodName);
        return record;
    }

    private Severity mapRubyLogLevel(IRubyObject arg2) {
        int rubyId = arg2.convertToInteger().getIntValue();
        switch (rubyId) {
            case 0: {
                return Severity.DEBUG;
            }
            case 1: {
                return Severity.INFO;
            }
            case 2: {
                return Severity.WARN;
            }
            case 3: {
                return Severity.ERROR;
            }
            case 4: {
                return Severity.FATAL;
            }
        }
        return Severity.UNKNOWN;
    }

    private String formatMessage(IRubyObject msg) {
        if (this.getRuntime().getString().equals(msg.getType())) {
            return msg.asJavaString();
        }
        if (this.getRuntime().getHash().equals(msg.getType())) {
            RubyHash hash2 = (RubyHash)msg;
            return Objects.toString(hash2.get(this.getRuntime().newSymbol(LOG_PROPERTY_TEXT)));
        }
        throw new IllegalArgumentException(Objects.toString(msg));
    }

    private Cursor getSourceLocation(IRubyObject msg) {
        RubyHash hash2;
        Object sourceLocation;
        if (this.getRuntime().getHash().equals(msg.getType()) && (sourceLocation = (hash2 = (RubyHash)msg).get(this.getRuntime().newSymbol(LOG_PROPERTY_SOURCE_LOCATION))) != null) {
            return new CursorImpl((IRubyObject)sourceLocation);
        }
        return null;
    }
}

