/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.fontawesome;

import de.jensd.fx.fontawesome.AwesomeIcon;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.TreeItem;
import javafx.scene.text.Font;

public class AwesomeDude {
    public static final String FONT_AWESOME_TTF_PATH = "/font/fontawesome-webfont.ttf";
    public static final String DEFAULT_ICON_SIZE = "16.0";
    public static final String DEFAULT_FONT_SIZE = "1em";

    public static Label createIconLabel(AwesomeIcon icon) {
        return AwesomeDude.createIconLabel(icon, DEFAULT_ICON_SIZE);
    }

    public static Label createIconLabel(AwesomeIcon icon, String iconSize) {
        Label label = new Label(icon.toString());
        label.getStyleClass().add((Object)"awesome");
        label.setStyle("-fx-font-family: FontAwesome; -fx-font-size: " + iconSize + ";");
        return label;
    }

    public static Label createIconLabel(AwesomeIcon icon, String text, String iconSize, String fontSize, ContentDisplay contentDisplay) {
        Label iconLabel = AwesomeDude.createIconLabel(icon, iconSize);
        Label label = new Label(text);
        label.setStyle("-fx-font-size: " + fontSize);
        label.setGraphic((Node)iconLabel);
        label.setContentDisplay(contentDisplay);
        return label;
    }

    public static Button createIconButton(AwesomeIcon icon) {
        return AwesomeDude.createIconButton(icon, "");
    }

    public static Button createIconButton(AwesomeIcon icon, String text) {
        Label label = AwesomeDude.createIconLabel(icon, DEFAULT_ICON_SIZE);
        Button button = new Button(text);
        button.setGraphic((Node)label);
        return button;
    }

    public static Button createIconButton(AwesomeIcon icon, String text, String iconSize, String fontSize, ContentDisplay contentDisplay) {
        Label label = AwesomeDude.createIconLabel(icon, iconSize);
        Button button = new Button(text);
        button.setStyle("-fx-font-size: " + fontSize);
        button.setGraphic((Node)label);
        button.setContentDisplay(contentDisplay);
        return button;
    }

    public static ToggleButton createIconToggleButton(AwesomeIcon icon, String text, String iconSize, ContentDisplay contentDisplay) {
        return AwesomeDude.createIconToggleButton(icon, text, iconSize, DEFAULT_FONT_SIZE, contentDisplay);
    }

    public static ToggleButton createIconToggleButton(AwesomeIcon icon, String text, String iconSize, String fontSize, ContentDisplay contentDisplay) {
        Label label = AwesomeDude.createIconLabel(icon, iconSize);
        ToggleButton button = new ToggleButton(text);
        button.setStyle("-fx-font-size: " + fontSize);
        button.setGraphic((Node)label);
        button.setContentDisplay(contentDisplay);
        return button;
    }

    public static void setIcon(Tab tab, AwesomeIcon icon) {
        AwesomeDude.setIcon(tab, icon, DEFAULT_ICON_SIZE);
    }

    public static void setIcon(Tab tab, AwesomeIcon icon, String iconSize) {
        tab.setGraphic((Node)AwesomeDude.createIconLabel(icon, iconSize));
    }

    public static void setIcon(Labeled labeled, AwesomeIcon icon) {
        AwesomeDude.setIcon(labeled, icon, DEFAULT_ICON_SIZE);
    }

    public static void setIcon(Labeled labeled, AwesomeIcon icon, ContentDisplay contentDisplay) {
        AwesomeDude.setIcon(labeled, icon, DEFAULT_ICON_SIZE, contentDisplay);
    }

    public static void setIcon(Labeled labeled, AwesomeIcon icon, String iconSize) {
        AwesomeDude.setIcon(labeled, icon, iconSize, ContentDisplay.LEFT);
    }

    public static void setIcon(Labeled labeled, AwesomeIcon icon, String iconSize, ContentDisplay contentDisplay) {
        if (labeled == null) {
            throw new IllegalArgumentException("The component must not be 'null'!");
        }
        labeled.setGraphic((Node)AwesomeDude.createIconLabel(icon, iconSize));
        labeled.setContentDisplay(contentDisplay);
    }

    public static void setIcon(MenuItem menuItem, AwesomeIcon icon) {
        AwesomeDude.setIcon(menuItem, icon, DEFAULT_FONT_SIZE, DEFAULT_ICON_SIZE);
    }

    public static void setIcon(MenuItem menuItem, AwesomeIcon icon, String iconSize) {
        AwesomeDude.setIcon(menuItem, icon, DEFAULT_FONT_SIZE, iconSize);
    }

    public static void setIcon(MenuItem menuItem, AwesomeIcon icon, String fontSize, String iconSize) {
        if (menuItem == null) {
            throw new IllegalArgumentException("The menu item must not be 'null'!");
        }
        Label label = AwesomeDude.createIconLabel(icon, iconSize);
        menuItem.setStyle("-fx-font-size: " + fontSize);
        menuItem.setGraphic((Node)label);
    }

    public static void setIcon(TreeItem treeItem, AwesomeIcon icon) {
        AwesomeDude.setIcon(treeItem, icon, DEFAULT_ICON_SIZE);
    }

    public static void setIcon(TreeItem treeItem, AwesomeIcon icon, String iconSize) {
        if (treeItem == null) {
            throw new IllegalArgumentException("The tree item must not be 'null'!");
        }
        Label label = AwesomeDude.createIconLabel(icon, iconSize);
        treeItem.setGraphic((Node)label);
    }

    static {
        Font.loadFont((String)AwesomeDude.class.getResource(FONT_AWESOME_TTF_PATH).toExternalForm(), (double)10.0);
    }
}

