/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.fontawesome;

import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import javafx.beans.NamedArg;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.text.Font;

public class Icon
extends Label {
    @FXML
    void initialize() {
    }

    public Icon(AwesomeIcon icon, String size, String style, String styleClass) {
        this.setText(icon.toString());
        this.getStyleClass().add((Object)"awesome");
        if (styleClass != null && !styleClass.isEmpty()) {
            this.getStyleClass().add((Object)styleClass);
        }
        size = size == null || size.isEmpty() ? "2em" : size;
        String stylePrefix = String.format("-fx-font-family: FontAwesome; -fx-font-size: %s;", size);
        this.setStyle(stylePrefix + style);
    }

    public Icon(@NamedArg(value="awesomeIcon") String awesomeIcon, @NamedArg(value="size") String size, @NamedArg(value="style") String style, @NamedArg(value="styleClass") String styleClass) {
        this(AwesomeIcon.valueOf(awesomeIcon), size, style, styleClass);
    }

    public Icon(@NamedArg(value="awesomeIcon") String awesomeIcon, @NamedArg(value="size") String size, @NamedArg(value="styleClass") String styleClass) {
        this(AwesomeIcon.valueOf(awesomeIcon), size, null, styleClass);
    }

    public Icon(@NamedArg(value="awesomeIcon") String awesomeIcon, @NamedArg(value="size") String size) {
        this(AwesomeIcon.valueOf(awesomeIcon), size, null, null);
    }

    public Icon(@NamedArg(value="awesomeIcon") String awesomeIcon) {
        this(AwesomeIcon.valueOf(awesomeIcon), "2em", null, null);
    }

    private Icon() {
        this(AwesomeIcon.STAR, "2em", null, null);
    }

    public static Icon create() {
        return new Icon();
    }

    public Icon icon(AwesomeIcon icon) {
        this.setText(icon.toString());
        return this;
    }

    public Icon size(String iconSize) {
        this.setStyle("-fx-font-size: " + iconSize + ";");
        return this;
    }

    public Icon style(String style) {
        this.setStyle(style);
        return this;
    }

    public Icon styleClass(String styleClass) {
        this.getStyleClass().add((Object)styleClass);
        return this;
    }

    static {
        Font.loadFont((String)AwesomeDude.class.getResource("/font/fontawesome-webfont.ttf").toExternalForm(), (double)10.0);
    }
}

