/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs;

import de.jensd.fx.glyphs.GlyphIcons;
import java.lang.reflect.ParameterizedType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.text.Text;

public abstract class GlyphIcon<T extends Enum<T>>
extends Text {
    public static final String DEFAULT_ICON_SIZE = "16.0";
    public static final String DEFAULT_FONT_SIZE = "1em";
    private StringProperty size;
    private StringProperty glyphStyle;
    private StringProperty glyphName;
    public final Class<T> typeOfT = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @FXML
    public void init() {
    }

    public GlyphIcon() {
        this.getStyleClass().addAll((Object[])new String[]{"root", "glyph-icon"});
        this.sizeProperty().addListener((observable, oldValue, newValue) -> this.updateStyle());
        this.glyphStyleProperty().addListener((observable, oldValue, newValue) -> this.updateStyle());
        this.glyphNameProperty().addListener((observable, oldValue, newValue) -> this.updateStyle());
        this.setIcon(this.getDefaultGlyph());
    }

    public final GlyphIcon setStyleClass(String styleClass) {
        this.getStyleClass().add((Object)styleClass);
        return this;
    }

    public final StringProperty glyphStyleProperty() {
        if (this.glyphStyle == null) {
            this.glyphStyle = new SimpleStringProperty("");
        }
        return this.glyphStyle;
    }

    public final String getGlyphStyle() {
        return this.glyphStyleProperty().getValue();
    }

    public final void setGlyphStyle(String style) {
        this.glyphStyleProperty().setValue(style);
    }

    public final StringProperty sizeProperty() {
        if (this.size == null) {
            this.size = new SimpleStringProperty(DEFAULT_FONT_SIZE);
        }
        return this.size;
    }

    public final String getSize() {
        return this.sizeProperty().getValue();
    }

    public final void setSize(String size) {
        size = size == null || size.isEmpty() ? DEFAULT_FONT_SIZE : size;
        this.sizeProperty().setValue(size);
    }

    public final StringProperty glyphNameProperty() {
        if (this.glyphName == null) {
            this.glyphName = new SimpleStringProperty("");
        }
        return this.glyphName;
    }

    public final String getGlyphName() {
        return this.glyphNameProperty().getValue();
    }

    public final void setGlyphName(String glyphName) {
        this.glyphNameProperty().setValue(glyphName);
    }

    public final void setIcon(T glyph) {
        this.setGlyphName(((Enum)glyph).name());
    }

    public abstract T getDefaultGlyph();

    private void updateStyle() {
        GlyphIcons icon = (GlyphIcons)this.getDefaultGlyph();
        try {
            icon = (GlyphIcons)Enum.valueOf(this.typeOfT, this.getGlyphName());
        }
        catch (Exception e) {
            String msg = String.format("Icon '%s' not found. Using '%s' (default) instead", this.getGlyphName(), this.getDefaultGlyph());
            Logger.getLogger(GlyphIcon.class.getName()).log(Level.SEVERE, msg);
        }
        this.setText(icon.characterToString());
        String style = String.format("-fx-font-family: %s; -fx-font-size: %s; %s", icon.getFontFamily(), this.getSize(), this.getGlyphStyle());
        this.setStyle(style);
    }
}

