/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs.testapps;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcons;
import de.jensd.fx.glyphs.testapps.AwesomeIconNameComparator;
import de.jensd.fx.glyphs.testapps.WeatherIconNameComparator;
import de.jensd.fx.glyphs.weathericons.WeatherIcons;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class GlyphsBrowser
extends VBox {
    @FXML
    private ResourceBundle resources;
    @FXML
    private FlowPane iconsBox;
    @FXML
    private HBox headerBox;
    @FXML
    private Label numberOfIconsLabel;
    @FXML
    private ScrollPane iconsScrollPane;
    private List<Button> listAwesome;
    private List<Button> listWeather;

    public GlyphsBrowser() {
        this.init();
    }

    private void init() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/messages");
            URL fxmlURL = ((Object)((Object)this)).getClass().getResource("/fxml/glyphs_browser.fxml");
            FXMLLoader fxmlLoader = new FXMLLoader(fxmlURL, resourceBundle);
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(GlyphsBrowser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    void initialize() {
        AwesomeIconNameComparator awesomeIconNameComparator = new AwesomeIconNameComparator();
        WeatherIconNameComparator weatherIconNameComparator = new WeatherIconNameComparator();
        this.listAwesome = Stream.of(FontAwesomeIcons.values()).sorted(awesomeIconNameComparator).map(i -> GlyphsBrowser.createIconButton(i, i.name())).collect(Collectors.toList());
        this.listWeather = Stream.of(WeatherIcons.values()).sorted(weatherIconNameComparator).map(i -> GlyphsBrowser.createIconButton(i, i.name())).collect(Collectors.toList());
        this.iconsBox.prefWidthProperty().bind((ObservableValue)this.iconsScrollPane.widthProperty().subtract(20.0));
    }

    private void updateBrowser(List iconsList) {
        this.iconsBox.getChildren().clear();
        this.iconsBox.getChildren().addAll((Collection)iconsList);
        this.numberOfIconsLabel.setText(iconsList.size() + "");
        this.iconsScrollPane.setVvalue(0.0);
    }

    @FXML
    public void onShowAwesomeIcons() {
        this.updateBrowser(this.listAwesome);
    }

    @FXML
    public void onShowWeatherIcons() {
        this.updateBrowser(this.listWeather);
    }

    private static Button createIconButton(FontAwesomeIcons icon, String text) {
        Tooltip tooltip = new Tooltip(String.format("%s: %s", icon.name(), icon.unicodeToString()));
        Text iconText = GlyphsDude.createIcon(icon, "2em");
        Button b = new Button(text);
        b.setContentDisplay(ContentDisplay.TOP);
        b.setGraphic((Node)iconText);
        b.setTooltip(tooltip);
        b.setPrefWidth(180.0);
        b.setOnAction(t -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(icon.name());
            clipboard.setContent((Map)content);
        });
        return b;
    }

    private static Button createIconButton(WeatherIcons icon, String text) {
        Tooltip tooltip = new Tooltip(String.format("%s: %s", icon.name(), icon.unicodeToString()));
        Text iconText = GlyphsDude.createIcon(icon, "2em");
        Button b = new Button(text);
        b.setContentDisplay(ContentDisplay.TOP);
        b.setGraphic((Node)iconText);
        b.setTooltip(tooltip);
        b.setPrefWidth(180.0);
        b.setOnAction(t -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(icon.name());
            clipboard.setContent((Map)content);
        });
        return b;
    }
}

