/*
 * Decompiled with CFR 0.152.
 */
package de.jensklingenberg.ktorfit.gradle;

import de.jensklingenberg.ktorfit.gradle.KtorfitCompilerSubPlugin;
import de.jensklingenberg.ktorfit.gradle.KtorfitGradlePluginKt;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilerPluginSupportPlugin;
import org.jetbrains.kotlin.gradle.plugin.SubpluginArtifact;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/jensklingenberg/ktorfit/gradle/KtorfitCompilerSubPlugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilerPluginSupportPlugin;", "()V", "myProject", "Lorg/gradle/api/Project;", "apply", "", "target", "applyToCompilation", "Lorg/gradle/api/provider/Provider;", "", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "checkKotlinVersion", "compilerVersion", "", "getCompilerPluginId", "getPluginArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "isApplicable", "", "ktorfit-gradle-plugin"})
public final class KtorfitCompilerSubPlugin
implements KotlinCompilerPluginSupportPlugin {
    private Project myProject;

    @NotNull
    public Provider<List<SubpluginOption>> applyToCompilation(@NotNull KotlinCompilation<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Provider provider = kotlinCompilation.getTarget().getProject().provider((Callable)applyToCompilation.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"kotlinCompilation.target\u2026,\n            )\n        }");
        return provider;
    }

    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.myProject = target;
    }

    @NotNull
    public String getCompilerPluginId() {
        return "ktorfitPlugin";
    }

    public boolean isApplicable(@NotNull KotlinCompilation<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
            project = null;
        }
        Object object = KtorfitGradlePluginKt.ktorfitExtension(project, "ktorfit").getKotlinVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"myProject.ktorfitExtensi\u2026    ).kotlinVersion.get()");
        String kotlinVersion = (String)object;
        return !Intrinsics.areEqual((Object)kotlinVersion, (Object)"-");
    }

    @NotNull
    public SubpluginArtifact getPluginArtifact() {
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
            project = null;
        }
        Object object = KotlinProjectExtensionKt.getKotlinExtension((Project)project).getCompilerVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"myProject.kotlinExtension.compilerVersion.get()");
        this.checkKotlinVersion((String)object);
        Project project2 = this.myProject;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
            project2 = null;
        }
        Object object2 = KtorfitGradlePluginKt.ktorfitExtension(project2, "ktorfit").getKotlinVersion().getOrElse((Object)"2.2.0");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"myProject.ktorfitExtensi\u2026_COMPILER_PLUGIN_VERSION)");
        String compilerVersion = (String)object2;
        return new SubpluginArtifact("de.jensklingenberg.ktorfit", "compiler-plugin", compilerVersion);
    }

    private final void checkKotlinVersion(String compilerVersion) {
        String[] stringArray = new String[]{"."};
        String string = (String)StringsKt.split$default((CharSequence)compilerVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        stringArray = new String[]{"."};
        if (string.compareTo((String)StringsKt.split$default((CharSequence)"2.1.0", (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)) < 0) {
            throw new IllegalStateException(("Ktorfit: Kotlin version " + compilerVersion + " is not supported. You need at least version 2.1.0").toString());
        }
    }

    @Nullable
    public SubpluginArtifact getPluginArtifactForNative() {
        return KotlinCompilerPluginSupportPlugin.DefaultImpls.getPluginArtifactForNative((KotlinCompilerPluginSupportPlugin)this);
    }
}

