/*
 * Decompiled with CFR 0.152.
 */
package jflex.maven.plugin.jflex;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jflex.core.OptionUtils;
import jflex.generator.LexGenerator;
import jflex.maven.plugin.jflex.LexSimpleAnalyzerUtils;
import jflex.maven.plugin.jflex.SpecInfo;
import jflex.option.Options;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=false)
public class JFlexMojo
extends AbstractMojo {
    private static final String SRC_MAIN_JFLEX = "src/main/jflex";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private File[] lexDefinitions;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jflex")
    private File outputDirectory;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="true")
    private boolean unusedWarning;
    @Parameter(defaultValue="false")
    private boolean dump;
    @Parameter(defaultValue="false")
    private boolean dot;
    @Parameter
    private File skeleton;
    @Parameter(defaultValue="false")
    private boolean jlex;
    @Parameter(defaultValue="pack")
    private String generationMethod = "pack";
    @Parameter(defaultValue="true")
    private boolean minimize = true;
    @Parameter(defaultValue="true")
    private boolean backup = true;
    @Parameter(defaultValue="false")
    private boolean legacyDot = false;
    @Parameter(defaultValue="")
    private String encodingName = "";

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<File> filesIt;
        this.outputDirectory = this.getAbsolutePath(this.outputDirectory);
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("outputDirectory is null");
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        if (this.lexDefinitions == null) {
            this.getLog().debug((CharSequence)"Use lexer files found in (default) src/main/jflex");
            filesIt = new ArrayList<File>();
            File defaultDir = this.getAbsolutePath(new File(SRC_MAIN_JFLEX));
            if (defaultDir.isDirectory()) {
                filesIt.add(defaultDir);
            }
        } else {
            filesIt = Arrays.asList(this.lexDefinitions);
            this.getLog().debug((CharSequence)("Parsing " + this.lexDefinitions.length + " jflex files or directories given in configuration"));
        }
        for (File lexDefinition : filesIt) {
            lexDefinition = this.getAbsolutePath(lexDefinition);
            this.parseLexDefinition(lexDefinition);
        }
    }

    private void parseLexDefinition(File lexDefinition) throws MojoFailureException, MojoExecutionException {
        assert (lexDefinition.isAbsolute()) : lexDefinition;
        if (lexDefinition.isDirectory()) {
            this.getLog().debug((CharSequence)("Processing lexer files found in " + lexDefinition));
            Iterable files = Iterables.filter((Iterable)Files.fileTraverser().depthFirstPreOrder((Object)lexDefinition), (Predicate)new ExtensionPredicate("jflex", "jlex", "lex", "flex"));
            for (File lexFile : files) {
                this.parseLexFile(lexFile);
            }
        } else {
            this.parseLexFile(lexDefinition);
        }
    }

    private void parseLexFile(File lexFile) throws MojoFailureException, MojoExecutionException {
        assert (lexFile.isAbsolute()) : lexFile;
        this.getLog().debug((CharSequence)("Generating Java code from " + lexFile.getName()));
        SpecInfo specInfo = this.findSpecInfo(lexFile);
        this.checkParameters(lexFile);
        File generatedFile = new File(this.outputDirectory, specInfo.getOutputFilename());
        long generatedLastModified = generatedFile.lastModified();
        if (lexFile.lastModified() - generatedLastModified <= (long)this.staleMillis && JFlexMojo.latestModified(specInfo.includedFiles) - generatedLastModified <= (long)this.staleMillis) {
            this.getLog().info((CharSequence)("  " + generatedFile.getName() + " is up to date."));
            this.getLog().debug((CharSequence)("StaleMillis = " + this.staleMillis + "ms"));
            return;
        }
        OptionUtils.setDefaultOptions();
        OptionUtils.setDir((File)generatedFile.getParentFile());
        Options.setRootDirectory((File)this.project.getBasedir());
        Options.dump = this.dump;
        Options.verbose = this.verbose;
        OptionUtils.set_unused_warning((boolean)this.unusedWarning);
        Options.dot = this.dot;
        Options.legacy_dot = this.legacyDot;
        if (this.skeleton != null) {
            OptionUtils.setSkeleton((File)this.skeleton);
        }
        Options.jlex = this.jlex;
        Options.no_minimize = !this.minimize;
        boolean bl = Options.no_backup = !this.backup;
        if (!Objects.equals("pack", this.generationMethod)) {
            throw new MojoExecutionException("Illegal generation method: " + this.generationMethod);
        }
        if (!Strings.isNullOrEmpty((String)this.encodingName)) {
            try {
                OptionUtils.setEncoding((String)this.encodingName);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        try {
            new LexGenerator(lexFile).generate();
            this.getLog().info((CharSequence)("  generated " + generatedFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private SpecInfo findSpecInfo(File lexFile) throws MojoFailureException {
        try {
            return LexSimpleAnalyzerUtils.guessSpecInfo(lexFile);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            return new SpecInfo("Yylex", "");
        }
    }

    private void checkParameters(File lexFile) throws MojoExecutionException {
        if (lexFile == null) {
            throw new MojoExecutionException("<lexDefinition> is empty. Please define input file with <lexDefinition>input.jflex</lexDefinition>");
        }
        if (!lexFile.isFile()) {
            throw new MojoExecutionException("Input file does not exist: " + lexFile);
        }
    }

    private File getAbsolutePath(File path) {
        if (path == null || path.isAbsolute()) {
            return path;
        }
        return new File(this.project.getBasedir().getAbsolutePath(), path.getPath());
    }

    private static long latestModified(Set<File> includedFiles) {
        long result = 0L;
        for (File file : includedFiles) {
            result = Math.max(file.lastModified(), result);
        }
        return result;
    }

    static class ExtensionPredicate
    implements Predicate<File> {
        final ImmutableSet<String> extensions;

        ExtensionPredicate(ImmutableSet<String> extensions) {
            this.extensions = extensions;
        }

        ExtensionPredicate(String ... extensions) {
            this((ImmutableSet<String>)ImmutableSet.copyOf((Object[])extensions));
        }

        public boolean apply(File file) {
            return this.extensions.contains((Object)Files.getFileExtension((String)file.getName()));
        }
    }
}

