/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.c;

import de.jplag.c.AbstractCharStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class JavaCharStream
extends AbstractCharStream {
    protected static final int NEXTCHAR_BUF_SIZE = 4096;
    private char[] m_aNextCharBuf = new char[4096];
    private int nextCharInd = -1;
    private Reader m_aIS;

    @Override
    protected int streamRead(char[] buffer, int offset, int len) throws IOException {
        return this.m_aIS.read(buffer, offset, len);
    }

    @Override
    protected void streamClose() throws IOException {
        this.m_aIS.close();
    }

    @Override
    protected void fillBuff() throws IOException {
        if (this.maxNextCharInd == 4096) {
            this.maxNextCharInd = 0;
            this.nextCharInd = 0;
        }
        try {
            int nCharsRead = this.streamRead(this.m_aNextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (nCharsRead == -1) {
                this.streamClose();
                throw new IOException();
            }
            this.maxNextCharInd += nCharsRead;
        }
        catch (IOException ex) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.internalSetBufLineColumn(this.getLine(), this.getColumn());
            }
            throw ex;
        }
    }

    private char readByte() throws IOException {
        ++this.nextCharInd;
        if (this.nextCharInd >= this.maxNextCharInd) {
            this.fillBuff();
        }
        return this.m_aNextCharBuf[this.nextCharInd];
    }

    @Override
    public char beginToken() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            this.tokenBegin = this.bufpos;
            return this.buffer[this.bufpos];
        }
        this.tokenBegin = 0;
        this.bufpos = -1;
        return this.readChar();
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            ++this.bufpos;
            if (this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        ++this.bufpos;
        if (this.bufpos == this.available) {
            this.internalAdjustBuffSize();
        }
        this.buffer[this.bufpos] = c = this.readByte();
        if (c != '\\') {
            if (this.isTrackLineColumn()) {
                this.internalUpdateLineColumn(c);
            }
            return c;
        }
        if (this.isTrackLineColumn()) {
            this.internalUpdateLineColumn(c);
        }
        int backSlashCnt = 1;
        while (true) {
            ++this.bufpos;
            if (this.bufpos == this.available) {
                this.internalAdjustBuffSize();
            }
            try {
                this.buffer[this.bufpos] = c = this.readByte();
                if (c != '\\') {
                    if (this.isTrackLineColumn()) {
                        this.internalUpdateLineColumn(c);
                    }
                    if (c == 'u' && (backSlashCnt & 1) == 1) {
                        --this.bufpos;
                        if (this.bufpos >= 0) break;
                        this.bufpos = this.bufsize - 1;
                        break;
                    }
                    this.backup(backSlashCnt);
                    return '\\';
                }
            }
            catch (IOException e) {
                if (backSlashCnt > 1) {
                    this.backup(backSlashCnt - 1);
                }
                return '\\';
            }
            if (this.isTrackLineColumn()) {
                this.internalUpdateLineColumn(c);
            }
            ++backSlashCnt;
        }
        try {
            while ((c = this.readByte()) == 'u') {
                if (!this.isTrackLineColumn()) continue;
                this.internalUpdateLineColumn(c);
            }
            char c1 = c;
            char c2 = this.readByte();
            char c3 = this.readByte();
            char c4 = this.readByte();
            this.buffer[this.bufpos] = c = (char)(JavaCharStream.hexval(c1) << 12 | JavaCharStream.hexval(c2) << 8 | JavaCharStream.hexval(c3) << 4 | JavaCharStream.hexval(c4));
            if (this.isTrackLineColumn()) {
                this.internalUpdateLineColumn(c1);
                this.internalUpdateLineColumn(c2);
                this.internalUpdateLineColumn(c3);
                this.internalUpdateLineColumn(c4);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Invalid escape character at line " + this.getLine() + " column " + this.getColumn() + ".");
        }
        if (backSlashCnt == 1) {
            return c;
        }
        this.backup(backSlashCnt - 1);
        return '\\';
    }

    public JavaCharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        super(startline, startcolumn, buffersize);
        this.m_aIS = dstream;
    }

    public JavaCharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public JavaCharStream(Reader dstream) {
        this(dstream, 1, 1, 4096);
    }

    public void reInit(Reader dstream) {
        this.reInit(dstream, 1, 1, 4096);
    }

    public void reInit(Reader dstream, int startline, int startcolumn) {
        this.reInit(dstream, startline, startcolumn, 4096);
    }

    public void reInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.m_aNextCharBuf = new char[4096];
        this.nextCharInd = -1;
        this.m_aIS = dstream;
        super.reInit(startline, startcolumn, buffersize);
    }

    public JavaCharStream(InputStream dstream, String encoding, int startline, int startcolumn, int buffersize) throws UnsupportedEncodingException {
        this(new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    public JavaCharStream(InputStream dstream, String encoding, int startline, int startcolumn) throws UnsupportedEncodingException {
        this(dstream, encoding, startline, startcolumn, 4096);
    }

    public JavaCharStream(InputStream dstream, String encoding) throws UnsupportedEncodingException {
        this(dstream, encoding, 1, 1, 4096);
    }

    public void reInit(InputStream dstream, String encoding) throws UnsupportedEncodingException {
        this.reInit(dstream, encoding, 1, 1, 4096);
    }

    public void reInit(InputStream dstream, String encoding, int startline, int startcolumn) throws UnsupportedEncodingException {
        this.reInit(dstream, encoding, startline, startcolumn, 4096);
    }

    public void reInit(InputStream dstream, String encoding, int startline, int startcolumn, int buffersize) throws UnsupportedEncodingException {
        this.reInit(new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    @Override
    public void done() {
        this.m_aNextCharBuf = null;
        super.done();
    }
}

