/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.c.experimental;

import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.c.CTokenType;
import java.util.List;
import java.util.ListIterator;

public final class UnreachableCodeFilter {
    private UnreachableCodeFilter() {
    }

    public static void applyTo(List<Token> tokenList) {
        TokenFilterState stateMachine = TokenFilterState.STATE_DEFAULT;
        ListIterator<Token> iterator = tokenList.listIterator();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (!(stateMachine = stateMachine.nextState(token.getType())).shouldTokenBeDeleted()) continue;
            iterator.remove();
        }
    }

    private static enum TokenFilterState {
        STATE_DEFAULT{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockStartToken(nextType)) {
                    return STATE_BLOCK_BEGINNING;
                }
                if (TokenFilterState.isJumpToken(nextType)) {
                    return STATE_DEAD_BLOCK_BEGINNING;
                }
                if (nextType == CTokenType.C_CASE) {
                    return STATE_CASE_BLOCK;
                }
                return STATE_DEFAULT;
            }
        }
        ,
        STATE_BLOCK_BEGINNING{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType) || nextType == CTokenType.C_BLOCK_BEGIN) {
                    return STATE_DEFAULT;
                }
                return STATE_BLOCK_BEGINNING;
            }
        }
        ,
        STATE_DEAD_BLOCK{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType)) {
                    return STATE_DEFAULT;
                }
                if (nextType == CTokenType.C_CASE) {
                    return STATE_CASE_BLOCK;
                }
                return STATE_DEAD_BLOCK;
            }

            @Override
            public boolean shouldTokenBeDeleted() {
                return true;
            }
        }
        ,
        STATE_DEAD_BLOCK_BEGINNING{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType)) {
                    return STATE_DEFAULT;
                }
                if (nextType == CTokenType.C_CASE) {
                    return STATE_CASE_BLOCK;
                }
                return STATE_DEAD_BLOCK;
            }
        }
        ,
        STATE_CASE_BLOCK{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType)) {
                    return STATE_DEFAULT;
                }
                if (TokenFilterState.isJumpToken(nextType)) {
                    return STATE_DEAD_BLOCK_BEGINNING;
                }
                return STATE_CASE_BLOCK;
            }
        };


        private static boolean isBlockStartToken(TokenType token) {
            return token == CTokenType.C_WHILE || token == CTokenType.C_IF || token == CTokenType.C_FOR;
        }

        private static boolean isBlockEndToken(TokenType token) {
            return token == CTokenType.C_BLOCK_END || token == SharedTokenType.FILE_END;
        }

        private static boolean isJumpToken(TokenType token) {
            return token == CTokenType.C_RETURN || token == CTokenType.C_BREAK || token == CTokenType.C_CONTINUE || token == CTokenType.C_THROW || token == CTokenType.C_GOTO;
        }

        public boolean shouldTokenBeDeleted() {
            return false;
        }

        abstract TokenFilterState nextState(TokenType var1);
    }
}

