/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.chars;

import de.jplag.AbstractParser;
import de.jplag.Token;
import de.jplag.TokenConstants;
import de.jplag.TokenList;
import de.jplag.chars.CharToken;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;

public class Parser
extends AbstractParser
implements TokenConstants {
    private TokenList struct;
    private int[] mapping = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, -1, -1, -1, -1, -1, -1, -1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, -1, -1, -1, -1, -1, -1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, -1, -1, -1, -1, -1};

    public TokenList parse(File dir, String[] files) {
        this.struct = new TokenList();
        this.errors = 0;
        for (String file : files) {
            this.getErrorConsumer().print(null, "Parsing file " + file);
            if (!this.parseFile(dir, file)) {
                ++this.errors;
            }
            this.struct.addToken((Token)new CharToken(0, file, this));
        }
        if (this.errors == 0) {
            this.errorConsumer.print(null, "OK");
        } else {
            this.errorConsumer.print(null, this.errors + " ERROR" + (this.errors > 1 ? "S" : ""));
        }
        this.parseEnd();
        return this.struct;
    }

    private boolean parseFile(File dir, String file) {
        char[] buffer = new char[4096];
        int offset = 0;
        try {
            int length;
            FileReader reader = new FileReader(new File(dir, file), StandardCharsets.UTF_8);
            do {
                length = reader.read(buffer);
                for (int i = 0; i < length; ++i) {
                    int type;
                    if (buffer[i] > '\u007f' || (type = this.mapping[buffer[i]]) <= 1) continue;
                    this.struct.addToken((Token)new CharToken(type, file, offset + i, this));
                }
                offset += length;
            } while (length != -1);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

