/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.cpp.experimental;

import de.jplag.cpp.Token;
import de.jplag.cpp.experimental.SourceAnalysis;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCCSourceAnalysis
implements SourceAnalysis {
    public static final String COMPILE_COMMAND = "gcc -Wall -fsyntax-only %s";
    private Map<String, List<Integer>> linesToDelete = new HashMap<String, List<Integer>>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean isTokenIgnored(Token token, File file) {
        String fileName = file.getName();
        if (this.linesToDelete.containsKey(fileName)) {
            List<Integer> ignoredLineNumbers = this.linesToDelete.get(fileName);
            return ignoredLineNumbers.contains(token.beginLine);
        }
        return false;
    }

    @Override
    public void findUnusedVariableLines(Set<File> files) throws InterruptedException {
        this.linesToDelete = new HashMap<String, List<Integer>>();
        for (File file : files) {
            try {
                String line;
                Runtime runtime = Runtime.getRuntime();
                Process gcc = runtime.exec(COMPILE_COMMAND.formatted(file.getAbsolutePath()));
                gcc.waitFor();
                BufferedReader stdError = new BufferedReader(new InputStreamReader(gcc.getErrorStream()));
                while ((line = stdError.readLine()) != null) {
                    this.processOutputLine(line);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to compile file {}", (Object)file.getAbsolutePath());
            }
        }
    }

    private void processOutputLine(String line) {
        if (!line.contains("unused variable")) {
            return;
        }
        String[] lineSplit = line.split(":");
        String fileName = new File(lineSplit[0]).getName();
        int lineNumber = Integer.parseInt(lineSplit[1]);
        this.linesToDelete.computeIfAbsent(fileName, key -> new ArrayList()).add(lineNumber);
    }
}

