/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.java;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DefaultCaseLabelTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.java.JavaTokenType;
import de.jplag.java.Parser;
import de.jplag.semantics.CodeSemantics;
import de.jplag.semantics.VariableAccessType;
import de.jplag.semantics.VariableRegistry;
import de.jplag.semantics.VariableScope;
import java.io.File;
import java.util.Set;

final class TokenGeneratingTreeScanner
extends TreeScanner<Void, Void> {
    private static final String ANONYMOUS_VARIABLE_NAME = "";
    private final File file;
    private final Parser parser;
    private final LineMap map;
    private final SourcePositions positions;
    private final CompilationUnitTree ast;
    private final VariableRegistry variableRegistry;
    private static final Set<String> IMMUTABLES = Set.of("byte", "short", "int", "long", "float", "double", "boolean", "char", "Byte", "Short", "Integer", "Long", "Float", "Double", "Boolean", "Character", "String");
    private static final Set<String> CRITICAL_METHODS = Set.of("System.out.println", "System.out.print");

    public TokenGeneratingTreeScanner(File file, Parser parser, LineMap map, SourcePositions positions, CompilationUnitTree ast) {
        this.file = file;
        this.parser = parser;
        this.map = map;
        this.positions = positions;
        this.ast = ast;
        this.variableRegistry = new VariableRegistry();
    }

    public void addToken(TokenType type, File file, long line, long column, long length, CodeSemantics semantics) {
        this.parser.add(new Token(type, file, (int)line, (int)column, (int)length, semantics));
        this.variableRegistry.updateSemantics(semantics);
    }

    private void addToken(JavaTokenType tokenType, long position, int length, CodeSemantics semantics) {
        this.addToken(tokenType, this.file, this.map.getLineNumber(position), this.map.getColumnNumber(position), length, semantics);
    }

    private void addToken(JavaTokenType tokenType, long start, long end, CodeSemantics semantics) {
        this.addToken(tokenType, this.file, this.map.getLineNumber(start), this.map.getColumnNumber(start), end - start, semantics);
    }

    private boolean isMutable(Tree classTree) {
        return classTree == null || !IMMUTABLES.contains(classTree.toString());
    }

    @Override
    public Void visitBlock(BlockTree node, Void unused) {
        this.variableRegistry.enterLocalScope();
        super.visitBlock(node, null);
        this.variableRegistry.exitLocalScope();
        return null;
    }

    @Override
    public Void visitClass(ClassTree node, Void unused) {
        JavaTokenType tokenType;
        this.variableRegistry.registerVariable(node.getSimpleName().toString(), VariableScope.FILE, true);
        this.variableRegistry.enterClass();
        for (Tree tree : node.getMembers()) {
            if (tree.getKind() != Tree.Kind.VARIABLE) continue;
            VariableTree variableTree = (VariableTree)tree;
            String name = variableTree.getName().toString();
            boolean mutable = this.isMutable(variableTree.getType());
            this.variableRegistry.registerVariable(name, VariableScope.CLASS, mutable);
        }
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        CodeSemantics semantics = CodeSemantics.createControl();
        if (node.getKind() == Tree.Kind.ENUM) {
            this.addToken(JavaTokenType.J_ENUM_BEGIN, start, 4, semantics);
        } else if (node.getKind() == Tree.Kind.INTERFACE) {
            this.addToken(JavaTokenType.J_INTERFACE_BEGIN, start, 9, semantics);
        } else if (node.getKind() == Tree.Kind.RECORD) {
            this.addToken(JavaTokenType.J_RECORD_BEGIN, start, 1, semantics);
        } else if (node.getKind() == Tree.Kind.ANNOTATION_TYPE) {
            this.addToken(JavaTokenType.J_ANNO_T_BEGIN, start, 10, semantics);
        } else if (node.getKind() == Tree.Kind.CLASS) {
            this.addToken(JavaTokenType.J_CLASS_BEGIN, start, 5, semantics);
        }
        super.visitClass(node, null);
        switch (node.getKind()) {
            case ENUM: {
                JavaTokenType javaTokenType = JavaTokenType.J_ENUM_END;
                break;
            }
            case INTERFACE: {
                JavaTokenType javaTokenType = JavaTokenType.J_INTERFACE_END;
                break;
            }
            case RECORD: {
                JavaTokenType javaTokenType = JavaTokenType.J_RECORD_END;
                break;
            }
            case ANNOTATION_TYPE: {
                JavaTokenType javaTokenType = JavaTokenType.J_ANNO_T_END;
                break;
            }
            case CLASS: {
                JavaTokenType javaTokenType = JavaTokenType.J_CLASS_END;
                break;
            }
            default: {
                JavaTokenType javaTokenType = tokenType = null;
            }
        }
        if (tokenType != null) {
            semantics = CodeSemantics.createControl();
            this.addToken(tokenType, end, 1, semantics);
        }
        this.variableRegistry.exitClass();
        return null;
    }

    @Override
    public Void visitImport(ImportTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_IMPORT, start, 6, CodeSemantics.createKeep());
        return (Void)super.visitImport(node, null);
    }

    @Override
    public Void visitPackage(PackageTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_PACKAGE, start, 7, CodeSemantics.createControl());
        return (Void)super.visitPackage(node, null);
    }

    @Override
    public Void visitMethod(MethodTree node, Void unused) {
        this.variableRegistry.enterLocalScope();
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_METHOD_BEGIN, start, node.getName().length(), CodeSemantics.createControl());
        super.visitMethod(node, null);
        this.addToken(JavaTokenType.J_METHOD_END, end, 1, CodeSemantics.createControl());
        this.variableRegistry.addAllNonLocalVariablesAsReads();
        this.variableRegistry.exitLocalScope();
        return null;
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_SYNC_BEGIN, start, 12, CodeSemantics.createControl());
        super.visitSynchronized(node, null);
        this.addToken(JavaTokenType.J_SYNC_END, end, 1, CodeSemantics.createControl());
        return null;
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node.getStatement()) - 1L;
        this.addToken(JavaTokenType.J_LOOP_BEGIN, start, 2, CodeSemantics.createLoopBegin());
        this.scan(node.getStatement(), null);
        this.addToken(JavaTokenType.J_LOOP_END, end, 1, CodeSemantics.createLoopEnd());
        this.scan(node.getCondition(), null);
        return null;
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_LOOP_BEGIN, start, 5, CodeSemantics.createLoopBegin());
        super.visitWhileLoop(node, null);
        this.addToken(JavaTokenType.J_LOOP_END, end, 1, CodeSemantics.createLoopEnd());
        return null;
    }

    @Override
    public Void visitForLoop(ForLoopTree node, Void unused) {
        this.variableRegistry.enterLocalScope();
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_LOOP_BEGIN, start, 3, CodeSemantics.createLoopBegin());
        super.visitForLoop(node, null);
        this.addToken(JavaTokenType.J_LOOP_END, end, 1, CodeSemantics.createLoopEnd());
        this.variableRegistry.exitLocalScope();
        return null;
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void unused) {
        this.variableRegistry.enterLocalScope();
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_LOOP_BEGIN, start, 3, CodeSemantics.createLoopBegin());
        super.visitEnhancedForLoop(node, null);
        this.addToken(JavaTokenType.J_LOOP_END, end, 1, CodeSemantics.createLoopEnd());
        this.variableRegistry.exitLocalScope();
        return null;
    }

    @Override
    public Void visitSwitch(SwitchTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_SWITCH_BEGIN, start, 6, CodeSemantics.createControl());
        super.visitSwitch(node, null);
        this.addToken(JavaTokenType.J_SWITCH_END, end, 1, CodeSemantics.createControl());
        return null;
    }

    @Override
    public Void visitSwitchExpression(SwitchExpressionTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_SWITCH_BEGIN, start, 6, CodeSemantics.createControl());
        super.visitSwitchExpression(node, null);
        this.addToken(JavaTokenType.J_SWITCH_END, end, 1, CodeSemantics.createControl());
        return null;
    }

    @Override
    public Void visitCase(CaseTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_CASE, start, 4, CodeSemantics.createControl());
        this.scan(node.getLabels(), null);
        if (node.getGuard() != null) {
            this.addToken(JavaTokenType.J_IF_BEGIN, this.positions.getStartPosition(this.ast, node.getGuard()), 0, CodeSemantics.createControl());
        }
        this.scan(node.getGuard(), null);
        if (node.getCaseKind() == CaseTree.CaseKind.RULE) {
            this.scan(node.getBody(), null);
        } else {
            this.scan(node.getStatements(), null);
        }
        if (node.getGuard() != null) {
            this.addToken(JavaTokenType.J_IF_END, this.positions.getEndPosition(this.ast, node), 0, CodeSemantics.createControl());
        }
        return null;
    }

    @Override
    public Void visitTry(TryTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_TRY_BEGIN, start, 3, CodeSemantics.createControl());
        this.scan(node.getResources(), null);
        this.scan(node.getBlock(), null);
        long end = this.positions.getEndPosition(this.ast, node);
        this.scan(node.getCatches(), null);
        if (node.getFinallyBlock() != null) {
            start = this.positions.getStartPosition(this.ast, node.getFinallyBlock());
            this.addToken(JavaTokenType.J_FINALLY_BEGIN, start, 3, CodeSemantics.createControl());
            this.scan(node.getFinallyBlock(), null);
            end = this.positions.getEndPosition(this.ast, node.getFinallyBlock());
            this.addToken(JavaTokenType.J_FINALLY_END, end, 1, CodeSemantics.createControl());
        }
        this.addToken(JavaTokenType.J_TRY_END, end, 1, CodeSemantics.createControl());
        return null;
    }

    @Override
    public Void visitCatch(CatchTree node, Void unused) {
        this.variableRegistry.enterLocalScope();
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_CATCH_BEGIN, start, 5, CodeSemantics.createControl());
        super.visitCatch(node, null);
        this.addToken(JavaTokenType.J_CATCH_END, end, 1, CodeSemantics.createControl());
        this.variableRegistry.exitLocalScope();
        return null;
    }

    @Override
    public Void visitIf(IfTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_IF_BEGIN, start, 2, CodeSemantics.createControl());
        this.scan(node.getCondition(), null);
        this.scan(node.getThenStatement(), null);
        long end = this.positions.getEndPosition(this.ast, node.getThenStatement()) - 1L;
        this.addToken(JavaTokenType.J_IF_END, end, 1, CodeSemantics.createControl());
        boolean isElseOnly = false;
        if (node.getElseStatement() != null) {
            boolean bl = isElseOnly = node.getElseStatement().getKind() != Tree.Kind.IF;
            if (isElseOnly) {
                start = this.positions.getStartPosition(this.ast, node.getElseStatement());
                this.addToken(JavaTokenType.J_IF_BEGIN, start, 4, CodeSemantics.createControl());
            }
        }
        this.scan(node.getElseStatement(), null);
        if (isElseOnly) {
            end = this.positions.getEndPosition(this.ast, node) - 1L;
            this.addToken(JavaTokenType.J_IF_END, end, 1, CodeSemantics.createControl());
        }
        return null;
    }

    @Override
    public Void visitBreak(BreakTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_BREAK, start, 5, CodeSemantics.createControl());
        return (Void)super.visitBreak(node, null);
    }

    @Override
    public Void visitContinue(ContinueTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_CONTINUE, start, 8, CodeSemantics.createControl());
        return (Void)super.visitContinue(node, null);
    }

    @Override
    public Void visitReturn(ReturnTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_RETURN, start, 6, CodeSemantics.createControl());
        return (Void)super.visitReturn(node, null);
    }

    @Override
    public Void visitThrow(ThrowTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_THROW, start, 5, CodeSemantics.createControl());
        return (Void)super.visitThrow(node, null);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        if (!node.getTypeArguments().isEmpty()) {
            this.addToken(JavaTokenType.J_GENERIC, start, 3 + node.getIdentifier().toString().length(), new CodeSemantics());
        }
        this.addToken(JavaTokenType.J_NEWCLASS, start, 3, new CodeSemantics());
        super.visitNewClass(node, null);
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_GENERIC, start, 1, new CodeSemantics());
        return (Void)super.visitTypeParameter(node, null);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void unused) {
        boolean hasInit;
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_NEWARRAY, start, 3, new CodeSemantics());
        this.scan(node.getType(), null);
        this.scan(node.getDimensions(), null);
        boolean bl = hasInit = node.getInitializers() != null && !node.getInitializers().isEmpty();
        if (hasInit) {
            start = this.positions.getStartPosition(this.ast, node.getInitializers().get(0));
            this.addToken(JavaTokenType.J_ARRAY_INIT_BEGIN, start, 1, new CodeSemantics());
        }
        this.scan(node.getInitializers(), null);
        if (hasInit) {
            this.addToken(JavaTokenType.J_ARRAY_INIT_END, end, 1, new CodeSemantics());
        }
        return null;
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_ASSIGN, start, 1, new CodeSemantics());
        this.variableRegistry.setNextVariableAccessType(VariableAccessType.WRITE);
        return (Void)super.visitAssignment(node, null);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_ASSIGN, start, 1, new CodeSemantics());
        this.variableRegistry.setNextVariableAccessType(VariableAccessType.READ_WRITE);
        return (Void)super.visitCompoundAssignment(node, null);
    }

    @Override
    public Void visitUnary(UnaryTree node, Void unused) {
        if (Set.of(Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_DECREMENT).contains((Object)node.getKind())) {
            long start = this.positions.getStartPosition(this.ast, node);
            this.addToken(JavaTokenType.J_ASSIGN, start, 1, new CodeSemantics());
            this.variableRegistry.setNextVariableAccessType(VariableAccessType.READ_WRITE);
        }
        return (Void)super.visitUnary(node, null);
    }

    @Override
    public Void visitAssert(AssertTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_ASSERT, start, 6, CodeSemantics.createControl());
        return (Void)super.visitAssert(node, null);
    }

    @Override
    public Void visitVariable(VariableTree node, Void unused) {
        if (!node.getName().contentEquals(ANONYMOUS_VARIABLE_NAME)) {
            CodeSemantics semantics;
            long start = this.positions.getStartPosition(this.ast, node);
            String name = node.getName().toString();
            boolean inLocalScope = this.variableRegistry.inLocalScope();
            if (inLocalScope) {
                boolean mutable = this.isMutable(node.getType());
                this.variableRegistry.registerVariable(name, VariableScope.LOCAL, mutable);
                semantics = new CodeSemantics();
            } else {
                semantics = CodeSemantics.createKeep();
            }
            this.addToken(JavaTokenType.J_VARDEF, start, node.toString().length(), semantics);
            this.variableRegistry.setNextVariableAccessType(VariableAccessType.WRITE);
            this.variableRegistry.registerVariableAccess(name, !inLocalScope);
        }
        return (Void)super.visitVariable(node, null);
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_COND, start, 1, new CodeSemantics());
        return (Void)super.visitConditionalExpression(node, null);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node.getMethodSelect()) - start;
        CodeSemantics codeSemantics = CRITICAL_METHODS.contains(node.getMethodSelect().toString()) ? CodeSemantics.createCritical() : CodeSemantics.createControl();
        this.addToken(JavaTokenType.J_APPLY, start, end, codeSemantics);
        this.variableRegistry.addAllNonLocalVariablesAsReads();
        this.scan(node.getTypeArguments(), null);
        this.variableRegistry.setIgnoreNextVariableAccess(true);
        this.variableRegistry.setMutableWrite(true);
        this.scan(node.getMethodSelect(), null);
        this.scan(node.getArguments(), null);
        this.variableRegistry.setMutableWrite(false);
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_ANNO, start, 1, new CodeSemantics());
        return (Void)super.visitAnnotation(node, null);
    }

    @Override
    public Void visitModule(ModuleTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node) - 1L;
        this.addToken(JavaTokenType.J_MODULE_BEGIN, start, 6, CodeSemantics.createControl());
        super.visitModule(node, null);
        this.addToken(JavaTokenType.J_MODULE_END, end, 1, CodeSemantics.createControl());
        return null;
    }

    @Override
    public Void visitRequires(RequiresTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_REQUIRES, start, 8, CodeSemantics.createControl());
        return (Void)super.visitRequires(node, null);
    }

    @Override
    public Void visitProvides(ProvidesTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_PROVIDES, start, 8, CodeSemantics.createControl());
        return (Void)super.visitProvides(node, null);
    }

    @Override
    public Void visitExports(ExportsTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        this.addToken(JavaTokenType.J_EXPORTS, start, 7, CodeSemantics.createControl());
        return (Void)super.visitExports(node, null);
    }

    @Override
    public Void visitYield(YieldTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node);
        this.addToken(JavaTokenType.J_YIELD, start, end, CodeSemantics.createControl());
        return (Void)super.visitYield(node, null);
    }

    @Override
    public Void visitDefaultCaseLabel(DefaultCaseLabelTree node, Void unused) {
        long start = this.positions.getStartPosition(this.ast, node);
        long end = this.positions.getEndPosition(this.ast, node);
        this.addToken(JavaTokenType.J_DEFAULT, start, end, CodeSemantics.createControl());
        return (Void)super.visitDefaultCaseLabel(node, null);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void unused) {
        if (node.getExpression().toString().equals("this")) {
            this.variableRegistry.registerVariableAccess(node.getIdentifier().toString(), true);
        }
        this.variableRegistry.setIgnoreNextVariableAccess(false);
        return (Void)super.visitMemberSelect(node, null);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void unused) {
        this.variableRegistry.registerVariableAccess(node.toString(), false);
        return (Void)super.visitIdentifier(node, null);
    }
}

