/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.kotlin;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.kotlin.JPlagKotlinListener;
import de.jplag.kotlin.KotlinTokenType;
import de.jplag.kotlin.grammar.KotlinLexer;
import de.jplag.kotlin.grammar.KotlinParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class KotlinParserAdapter
extends AbstractParser {
    private File currentFile;
    private List<Token> tokens;

    public List<Token> parse(Set<File> files) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        for (File file : files) {
            this.parseFile(file);
            this.tokens.add(Token.fileEnd((File)file));
        }
        return this.tokens;
    }

    private void parseFile(File file) throws ParsingException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.currentFile = file;
            KotlinLexer lexer = new KotlinLexer(CharStreams.fromStream((InputStream)inputStream));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            KotlinParser parser = new KotlinParser((TokenStream)tokenStream);
            KotlinParser.KotlinFileContext entryContext = parser.kotlinFile();
            ParseTreeWalker treeWalker = new ParseTreeWalker();
            JPlagKotlinListener listener = new JPlagKotlinListener(this);
            for (int i = 0; i < entryContext.getChildCount(); ++i) {
                ParseTree parseTree = entryContext.getChild(i);
                treeWalker.walk((ParseTreeListener)listener, parseTree);
            }
        }
        catch (IOException exception) {
            throw new ParsingException(file, exception.getMessage(), (Throwable)exception);
        }
    }

    void addToken(KotlinTokenType tokenType, int line, int column, int length) {
        this.tokens.add(new Token((TokenType)tokenType, this.currentFile, line, column, length));
    }
}

