/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.antlr;

import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.semantics.CodeSemantics;
import de.jplag.semantics.VariableRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCollector {
    private static final Logger logger = LoggerFactory.getLogger(TokenCollector.class);
    private final List<Token> collected = new ArrayList<Token>();
    private final boolean extractsSemantics;
    private File file;

    TokenCollector(boolean extractsSemantics) {
        this.extractsSemantics = extractsSemantics;
    }

    List<Token> getTokens() {
        return Collections.unmodifiableList(this.collected);
    }

    <T> void addToken(TokenType jplagType, Function<T, CodeSemantics> semanticsSupplier, T entity, Function<T, org.antlr.v4.runtime.Token> extractStartToken, Function<T, org.antlr.v4.runtime.Token> extractEndToken, VariableRegistry variableRegistry) {
        Token token;
        if (jplagType == null) {
            return;
        }
        org.antlr.v4.runtime.Token antlrToken = extractStartToken.apply(entity);
        org.antlr.v4.runtime.Token antlrEndToken = extractEndToken.apply(entity);
        int line = antlrToken.getLine();
        int column = antlrToken.getCharPositionInLine() + 1;
        int length = antlrEndToken.getStopIndex() - antlrToken.getStartIndex() + 1;
        if (this.extractsSemantics) {
            if (semanticsSupplier == null) {
                throw new IllegalStateException(String.format("Expected semantics bud did not receive any for token %s", jplagType.getDescription()));
            }
            CodeSemantics semantics = semanticsSupplier.apply(entity);
            token = new Token(jplagType, this.file, line, column, length, semantics);
            variableRegistry.updateSemantics(semantics);
        } else {
            if (semanticsSupplier != null) {
                logger.warn("Received semantics for token {} despite not expecting any", (Object)jplagType.getDescription());
            }
            token = new Token(jplagType, this.file, line, column, length);
        }
        this.addToken(token);
    }

    void enterFile(File newFile) {
        this.file = newFile;
    }

    void addFileEndToken() {
        this.addToken(this.extractsSemantics ? Token.semanticFileEnd((File)this.file) : Token.fileEnd((File)this.file));
    }

    private void addToken(Token token) {
        this.collected.add(token);
    }
}

