/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.antlr;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.antlr.AbstractAntlrListener;
import de.jplag.antlr.AntlrLoggerErrorListener;
import de.jplag.antlr.InternalListener;
import de.jplag.antlr.TokenCollector;
import de.jplag.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public abstract class AbstractAntlrParserAdapter<T extends Parser>
extends AbstractParser {
    private final boolean extractsSemantics;

    protected AbstractAntlrParserAdapter(boolean extractsSemantics) {
        this.extractsSemantics = extractsSemantics;
    }

    protected AbstractAntlrParserAdapter() {
        this(false);
    }

    public List<Token> parse(Set<File> files) throws ParsingException {
        TokenCollector collector = new TokenCollector(this.extractsSemantics);
        for (File file : files) {
            this.parseFile(file, collector);
        }
        return collector.getTokens();
    }

    private void parseFile(File file, TokenCollector collector) throws ParsingException {
        collector.enterFile(file);
        try (BufferedReader reader = FileUtils.openFileReader((File)file);){
            Lexer lexer = this.createLexer((CharStream)CharStreams.fromReader((Reader)reader));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            T parser = this.createParser(tokenStream);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new AntlrLoggerErrorListener());
            ParserRuleContext entryContext = this.getEntryContext(parser);
            ParseTreeWalker treeWalker = new ParseTreeWalker();
            InternalListener listener = new InternalListener(this.getListener(), collector);
            for (ParseTree child : entryContext.children) {
                treeWalker.walk((ParseTreeListener)listener, child);
            }
        }
        catch (Exception exception) {
            throw new ParsingException(file, exception.getMessage(), (Throwable)exception);
        }
        collector.addFileEndToken();
    }

    protected abstract Lexer createLexer(CharStream var1);

    protected abstract T createParser(CommonTokenStream var1);

    protected abstract ParserRuleContext getEntryContext(T var1);

    protected abstract AbstractAntlrListener getListener();
}

