/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.antlr;

import de.jplag.TokenType;
import de.jplag.antlr.HandlerData;
import de.jplag.semantics.CodeSemantics;
import de.jplag.semantics.VariableRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.antlr.v4.runtime.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVisitor<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractVisitor.class);
    private final Predicate<T> condition;
    private final List<Consumer<HandlerData<T>>> entryHandlers;
    private Function<T, CodeSemantics> entrySemantics;
    protected TokenType entryTokenType;

    AbstractVisitor(Predicate<T> condition) {
        this.condition = condition;
        this.entryHandlers = new ArrayList<Consumer<HandlerData<T>>>();
    }

    public AbstractVisitor<T> onEnter(BiConsumer<T, VariableRegistry> handler) {
        this.entryHandlers.add(handlerData -> handler.accept(handlerData.entity(), handlerData.variableRegistry()));
        return this;
    }

    public AbstractVisitor<T> onEnter(Consumer<T> handler) {
        this.entryHandlers.add(handlerData -> handler.accept(handlerData.entity()));
        return this;
    }

    public AbstractVisitor<T> mapEnter(TokenType tokenType) {
        this.entryTokenType = tokenType;
        return this;
    }

    public AbstractVisitor<T> map(TokenType tokenType) {
        this.mapEnter(tokenType);
        return this;
    }

    public AbstractVisitor<T> withSemantics(Function<T, CodeSemantics> semanticsSupplier) {
        this.entrySemantics = semanticsSupplier;
        return this;
    }

    public AbstractVisitor<T> withSemantics(Supplier<CodeSemantics> semanticsSupplier) {
        this.withSemantics((T ignore) -> (CodeSemantics)semanticsSupplier.get());
        return this;
    }

    public AbstractVisitor<T> withControlSemantics() {
        this.withSemantics(CodeSemantics::createControl);
        return this;
    }

    boolean matches(T entity) {
        return this.condition.test(entity);
    }

    void enter(HandlerData<T> data) {
        this.handleEnter(data, this::extractEnterToken, this::extractEnterToken);
    }

    protected void handleEnter(HandlerData<T> data, Function<T, Token> extractStartToken, Function<T, Token> extractEndToken) {
        if (this.entryTokenType == null && this.entrySemantics != null) {
            logger.warn("Received semantics, but no token type, so no token was generated and the semantics discarded");
        }
        this.addToken(data, this.entryTokenType, this.entrySemantics, extractStartToken, extractEndToken);
        this.entryHandlers.forEach(handler -> handler.accept(data));
    }

    void addToken(HandlerData<T> data, TokenType tokenType, Function<T, CodeSemantics> semantics, Function<T, Token> extractToken) {
        this.addToken(data, tokenType, semantics, extractToken, extractToken);
    }

    void addToken(HandlerData<T> data, TokenType tokenType, Function<T, CodeSemantics> semantics, Function<T, Token> extractStartToken, Function<T, Token> extractEndToken) {
        data.collector().addToken(tokenType, semantics, data.entity(), extractStartToken, extractEndToken, data.variableRegistry());
    }

    abstract Token extractEnterToken(T var1);
}

