/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.antlr;

import de.jplag.TokenType;
import de.jplag.antlr.AbstractVisitor;
import de.jplag.antlr.ContextDelegateVisitor;
import de.jplag.antlr.DelegateVisitor;
import de.jplag.antlr.HandlerData;
import de.jplag.antlr.TerminalVisitor;
import de.jplag.semantics.CodeSemantics;
import de.jplag.semantics.VariableRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ContextVisitor<T extends ParserRuleContext>
extends AbstractVisitor<T> {
    private final List<Consumer<HandlerData<T>>> exitHandlers = new ArrayList<Consumer<HandlerData<T>>>();
    private TokenType exitTokenType;
    private Function<T, CodeSemantics> exitSemantics;
    private boolean lengthAsRange = false;
    private DelegateVisitor<T, ?> delegate = null;

    ContextVisitor(Predicate<T> condition) {
        super(condition);
    }

    public AbstractVisitor<T> onExit(BiConsumer<T, VariableRegistry> handler) {
        this.exitHandlers.add(handlerData -> handler.accept((ParserRuleContext)handlerData.entity(), handlerData.variableRegistry()));
        return this;
    }

    public AbstractVisitor<T> onExit(Consumer<T> handler) {
        this.exitHandlers.add(handlerData -> handler.accept((ParserRuleContext)handlerData.entity()));
        return this;
    }

    public ContextVisitor<T> mapExit(TokenType tokenType) {
        this.exitTokenType = tokenType;
        return this;
    }

    public AbstractVisitor<T> mapRange(TokenType tokenType) {
        this.entryTokenType = tokenType;
        this.lengthAsRange = true;
        return this;
    }

    public TerminalVisitor delegateTerminal(Function<T, TerminalNode> mapper) {
        TerminalVisitor delegateVisitor = new TerminalVisitor(ignore -> true);
        this.delegate = new DelegateVisitor<ParserRuleContext, Token>(delegateVisitor, parentData -> ((TerminalNode)mapper.apply(parentData)).getSymbol());
        return delegateVisitor;
    }

    public TerminalVisitor delegateTerminalExit(Function<T, TerminalNode> mapper) {
        TerminalVisitor delegateVisitor = new TerminalVisitor(ignore -> true);
        this.delegate = new DelegateVisitor<ParserRuleContext, Token>(delegateVisitor, parentData -> ((TerminalNode)mapper.apply(parentData)).getSymbol());
        this.delegate.mapOnExit();
        return delegateVisitor;
    }

    public <V extends ParserRuleContext> ContextVisitor<V> delegateContext(Function<T, V> mapper) {
        ContextVisitor<ParserRuleContext> visitor = new ContextVisitor<ParserRuleContext>(ignore -> true);
        this.delegate = new ContextDelegateVisitor<T, ParserRuleContext>(visitor, mapper);
        return visitor;
    }

    public ContextVisitor<T> mapEnterExit(TokenType enterTokenType, TokenType exitTokenType) {
        this.mapEnter(enterTokenType);
        this.mapExit(exitTokenType);
        return this;
    }

    public ContextVisitor<T> map(TokenType enterTokenType, TokenType exitTokenType) {
        this.mapEnterExit(enterTokenType, exitTokenType);
        return this;
    }

    @Override
    public ContextVisitor<T> withSemantics(Function<T, CodeSemantics> semantics) {
        super.withSemantics(semantics);
        this.exitSemantics = semantics;
        return this;
    }

    @Override
    public ContextVisitor<T> withSemantics(Supplier<CodeSemantics> semantics) {
        this.withSemantics((T ignore) -> (CodeSemantics)semantics.get());
        return this;
    }

    public ContextVisitor<T> withLoopSemantics() {
        super.withSemantics(CodeSemantics::createLoopBegin);
        this.exitSemantics = ignore -> CodeSemantics.createLoopEnd();
        return this;
    }

    public ContextVisitor<T> addLocalScope() {
        this.onEnter((T ignore, VariableRegistry variableRegistry) -> variableRegistry.enterLocalScope());
        this.onExit((T ignore, VariableRegistry variableRegistry) -> variableRegistry.exitLocalScope());
        return this;
    }

    public ContextVisitor<T> addClassScope() {
        this.onEnter((T ignore, VariableRegistry variableRegistry) -> variableRegistry.enterClass());
        this.onExit((T ignore, VariableRegistry variableRegistry) -> variableRegistry.exitClass());
        return this;
    }

    void exit(HandlerData<T> data) {
        if (this.delegate != null) {
            this.delegate.delegateExit(data);
            return;
        }
        this.addToken(data, this.exitTokenType, this.exitSemantics, ParserRuleContext::getStop);
        this.exitHandlers.forEach(handler -> handler.accept(data));
    }

    @Override
    void enter(HandlerData<T> data) {
        if (this.delegate != null) {
            this.delegate.delegateEnter(data);
            return;
        }
        if (this.lengthAsRange) {
            this.handleEnter(data, this::extractEnterToken, ParserRuleContext::getStop);
        } else {
            super.enter(data);
        }
    }

    @Override
    Token extractEnterToken(T entity) {
        return entity.getStart();
    }

    @Override
    boolean matches(T entity) {
        if (this.delegate != null && !this.delegate.isPresent(entity)) {
            return false;
        }
        return super.matches(entity);
    }
}

