/*
 * Decompiled with CFR 0.152.
 */
package de.jplag;

import de.jplag.SharedTokenType;
import de.jplag.TokenType;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Token {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int NO_VALUE = -1;
    private int line;
    private int column;
    private int length;
    private File file;
    private TokenType type;

    public static Token fileEnd(File file) {
        return new Token(SharedTokenType.FILE_END, file, -1, -1, -1);
    }

    public Token(TokenType type, File file, int line, int column, int length) {
        if (line == 0) {
            this.logger.warn("Creating a token with line index 0 while index is 1-based");
        }
        if (column == 0) {
            this.logger.warn("Creating a token with column index 0 while index is 1-based");
        }
        this.type = type;
        this.file = file;
        this.line = line;
        this.column = column;
        this.length = length;
    }

    public int getColumn() {
        return this.column;
    }

    public File getFile() {
        return this.file;
    }

    public int getLength() {
        return this.length;
    }

    public int getLine() {
        return this.line;
    }

    public TokenType getType() {
        return this.type;
    }
}

